/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.compatibility.VersionCompatibilityChecker;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityChecksMetadataUpdater
extends ApplicationComponent.Adapter {
    private static final Logger LOG = Logger.getInstance(CompatibilityChecksMetadataUpdater.class);
    private static final String LAST_CHECK_TIMESTAMP_PROPERTY_NAME = "android-component-compatibility-check";

    public CompatibilityChecksMetadataUpdater() {
        String checkIntervalProperty = System.getProperty("android.version.compatibility.check.interval");
        final CheckInterval checkInterval = CheckInterval.find(checkIntervalProperty);
        if (checkInterval != CheckInterval.NONE) {
            Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                    if (willOpenProject == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadataUpdater$1", "appFrameCreated"));
                    }
                    long lastUpdateCheck = PropertiesComponent.getInstance().getOrInitLong(CompatibilityChecksMetadataUpdater.LAST_CHECK_TIMESTAMP_PROPERTY_NAME, -1L);
                    if (checkInterval.needsUpdate(lastUpdateCheck)) {
                        CompatibilityChecksMetadataUpdater.fetchVersionMetadataUpdate(false);
                    }
                }
            });
        }
    }

    public void fetchVersionMetadataUpdate() {
        CompatibilityChecksMetadataUpdater.fetchVersionMetadataUpdate(true);
    }

    private static void fetchVersionMetadataUpdate(boolean startedByUser) {
        CompatibilityChecksMetadataUpdater.fetchMetadata().doWhenDone(() -> {
            long now = System.currentTimeMillis();
            PropertiesComponent.getInstance().setValue(LAST_CHECK_TIMESTAMP_PROPERTY_NAME, String.valueOf(now));
        });
    }

    @NotNull
    private static ActionCallback fetchMetadata() {
        ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String url = "https://dl.google.com/android/studio/metadata/android-component-compatibility.xml";
            try {
                Document metadata = (Document)HttpRequests.request((String)url).connect(request -> {
                    try {
                        return JDOMUtil.loadDocument((InputStream)request.getInputStream());
                    }
                    catch (JDOMException e) {
                        LOG.info("Failed to parse XML metadata", (Throwable)e);
                        return null;
                    }
                    catch (Throwable e) {
                        LOG.info("Failed to parse XML metadata", e);
                        return null;
                    }
                });
                if (metadata != null) {
                    VersionCompatibilityChecker.getInstance().updateMetadata(metadata);
                    callback.setDone();
                }
            }
            catch (IOException e) {
                LOG.info(String.format("Failed to connect to '%1$s'", url), (Throwable)e);
            }
            callback.setRejected();
        });
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadataUpdater", "fetchMetadata"));
        }
        return actionCallback;
    }

    static enum CheckInterval {
        NONE(Long.MAX_VALUE),
        DAILY(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)),
        WEEKLY(TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS)),
        TESTING(-1L);

        private final long myIntervalInMs;

        private CheckInterval(long intervalInMs) {
            this.myIntervalInMs = intervalInMs;
        }

        boolean needsUpdate(long lastUpdateTimestampInMs) {
            return System.currentTimeMillis() - lastUpdateTimestampInMs >= this.myIntervalInMs;
        }

        @NotNull
        static CheckInterval find(@Nullable String value) {
            if (StringUtil.isNotEmpty((String)value)) {
                for (CheckInterval checkInterval : CheckInterval.values()) {
                    if (!value.equalsIgnoreCase(checkInterval.name())) continue;
                    CheckInterval checkInterval2 = checkInterval;
                    if (checkInterval2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadataUpdater$CheckInterval", "find"));
                    }
                    return checkInterval2;
                }
            }
            CheckInterval checkInterval = WEEKLY;
            if (checkInterval == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadataUpdater$CheckInterval", "find"));
            }
            return checkInterval;
        }
    }
}

