/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityCheck;
import com.android.tools.idea.gradle.project.sync.compatibility.Component;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class VersionIncompatibility {
    @NotNull
    private final Module myModule;
    @NotNull
    private final CompatibilityCheck myCompatibilityCheck;
    @NotNull
    private final Pair<ComponentVersionReader, String> myReaderAndVersion;
    @NotNull
    private final Component myRequirement;
    @NotNull
    private final ComponentVersionReader myRequirementVersionReader;
    @NotNull
    private final List<String> myMessages;

    VersionIncompatibility(@NotNull Module module, @NotNull CompatibilityCheck compatibilityCheck, @NotNull Pair<ComponentVersionReader, String> readerAndVersion, @NotNull Component requirement, @NotNull ComponentVersionReader requirementVersionReader) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility", "<init>"));
        }
        if (compatibilityCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compatibilityCheck", "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility", "<init>"));
        }
        if (readerAndVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readerAndVersion", "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility", "<init>"));
        }
        if (requirement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirement", "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility", "<init>"));
        }
        if (requirementVersionReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirementVersionReader", "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility", "<init>"));
        }
        this.myMessages = new ArrayList<String>();
        this.myModule = module;
        this.myCompatibilityCheck = compatibilityCheck;
        this.myReaderAndVersion = readerAndVersion;
        this.myRequirement = requirement;
        this.myRequirementVersionReader = requirementVersionReader;
    }

    boolean hasMessages() {
        return !this.myMessages.isEmpty();
    }

    void addMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility", "addMessage"));
        }
        this.myMessages.add(message);
    }

    /*
     * WARNING - void declaration
     */
    void reportMessages(@NotNull Project project) {
        void var11_14;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility", "reportMessages"));
        }
        ComponentVersionReader reader = (ComponentVersionReader)this.myReaderAndVersion.getFirst();
        String componentName = reader.getComponentName();
        String version = (String)this.myReaderAndVersion.getSecond();
        String requirementComponentName = this.myRequirementVersionReader.getComponentName();
        StringBuilder msg = new StringBuilder();
        msg.append(componentName).append(" ").append(version);
        PositionInFile position = reader.getVersionSource(this.myModule);
        if (!reader.isProjectLevel() && position == null) {
            msg.append(", in module '").append(this.myModule.getName()).append(",'");
        }
        msg.append(" requires ").append(requirementComponentName).append(" ");
        VersionRange requirementVersionRange = this.myRequirement.getVersionRange();
        msg.append(requirementVersionRange.getDescription());
        int messageCount = this.myMessages.size();
        if (messageCount == 1) {
            msg.append(" ").append(this.myMessages.get(0));
        } else if (messageCount > 1) {
            msg.append("<ul>");
            for (String string : this.myMessages) {
                msg.append("<li>").append(string).append("</li>");
            }
            msg.append("</ul>");
        }
        MessageType messageType = this.myCompatibilityCheck.getType();
        ArrayList<String> textLines = new ArrayList<String>();
        textLines.add(msg.toString());
        String failureMsg = this.myRequirement.getFailureMessage();
        if (failureMsg != null) {
            List lines = Splitter.on((String)"\\n").omitEmptyStrings().splitToList((CharSequence)failureMsg);
            textLines.addAll(lines);
        }
        String[] text = ArrayUtil.toStringArray(textLines);
        if (position != null) {
            SyncMessage syncMessage = new SyncMessage(project, "Gradle Sync Issues", messageType, position, text);
        } else {
            SyncMessage syncMessage = new SyncMessage("Gradle Sync Issues", messageType, text);
        }
        var11_14.add(this.myRequirementVersionReader.getQuickFixes(this.myModule, requirementVersionRange, position));
        SyncMessages.getInstance(project).report((SyncMessage)var11_14);
    }

    @NotNull
    MessageType getType() {
        MessageType messageType = this.myCompatibilityCheck.getType();
        if (messageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility", "getType"));
        }
        return messageType;
    }
}

