/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionPermissionDeniedErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/ConnectionPermissionDeniedErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/ConnectionPermissionDeniedErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/ConnectionPermissionDeniedErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        if (rootCause instanceof SocketException && StringUtil.isNotEmpty((String)text) && text.contains("Permission denied: connect")) {
            ConnectionPermissionDeniedErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.CONNECTION_DENIED);
            return "Connection to the Internet denied.";
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/ConnectionPermissionDeniedErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/ConnectionPermissionDeniedErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/ConnectionPermissionDeniedErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        OpenUrlHyperlink quickFix = new OpenUrlHyperlink("https://developer.android.com/studio/troubleshoot.html#project-sync", "More details (and potential fix)");
        hyperlinks.add(quickFix);
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/ConnectionPermissionDeniedErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

