/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.google.common.base.Splitter;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenericErrorHandler
extends SyncErrorHandler {
    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        List<NotificationHyperlink> hyperlinks;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/errors/GenericErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/GenericErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/GenericErrorHandler", "handleError"));
        }
        String text = this.getRootCause((Throwable)error).getMessage();
        if (text != null && !(hyperlinks = this.getQuickFixHyperlinks(notification, text)).isEmpty()) {
            GenericErrorHandler.updateUsageTracker();
            SyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
            return true;
        }
        return false;
    }

    @NotNull
    private List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull String text) {
        Pair<String, Integer> errorLocation;
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/GenericErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/GenericErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        List message = Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text);
        String lastLine = (String)message.get(message.size() - 1);
        if (lastLine != null && (errorLocation = this.getErrorLocation(lastLine)) != null) {
            String filePath = (String)errorLocation.getFirst();
            int line = (Integer)errorLocation.getSecond();
            hyperlinks.add(new OpenFileHyperlink(filePath, line - 1));
            ArrayList<NotificationHyperlink> arrayList = hyperlinks;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/GenericErrorHandler", "getQuickFixHyperlinks"));
            }
            return arrayList;
        }
        String filePath = notification.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            int lineIndex = notification.getLine() - 1;
            int column = notification.getColumn();
            hyperlinks.add(new OpenFileHyperlink(filePath, "Open File", lineIndex, column));
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/GenericErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

