/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixAndroidGradlePluginVersionHyperlink
extends NotificationHyperlink {
    @NotNull
    private final GradleVersion myPluginVersion;
    @Nullable
    private final GradleVersion myGradleVersion;

    public FixAndroidGradlePluginVersionHyperlink() {
        this(GradleVersion.parse((String)AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion()), GradleVersion.parse((String)"3.3"));
    }

    public FixAndroidGradlePluginVersionHyperlink(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion) {
        if (pluginVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersion", "com/android/tools/idea/gradle/project/sync/hyperlink/FixAndroidGradlePluginVersionHyperlink", "<init>"));
        }
        this("Upgrade plugin to version " + pluginVersion + " and sync project", pluginVersion, gradleVersion);
    }

    public FixAndroidGradlePluginVersionHyperlink(@NotNull String text, @NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/hyperlink/FixAndroidGradlePluginVersionHyperlink", "<init>"));
        }
        if (pluginVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersion", "com/android/tools/idea/gradle/project/sync/hyperlink/FixAndroidGradlePluginVersionHyperlink", "<init>"));
        }
        super("fixGradleElements", text);
        this.myPluginVersion = pluginVersion;
        this.myGradleVersion = gradleVersion;
    }

    @Override
    public void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/FixAndroidGradlePluginVersionHyperlink", "execute"));
        }
        AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
        updater.updatePluginVersionAndSync(this.myPluginVersion, this.myGradleVersion, false);
    }

    @VisibleForTesting
    @NotNull
    public GradleVersion getPluginVersion() {
        GradleVersion gradleVersion = this.myPluginVersion;
        if (gradleVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/hyperlink/FixAndroidGradlePluginVersionHyperlink", "getPluginVersion"));
        }
        return gradleVersion;
    }

    @VisibleForTesting
    @Nullable
    public GradleVersion getGradleVersion() {
        return this.myGradleVersion;
    }
}

