/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.SelectNdkDialog;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNdkHyperlink
extends NotificationHyperlink {
    private static final String ERROR_TITLE = "Gradle Sync Error";

    public InstallNdkHyperlink() {
        super("install.ndk", "Install NDK and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallNdkHyperlink", "execute"));
        }
        File path = InstallNdkHyperlink.getNdkPath(project);
        if (path != null) {
            SelectNdkDialog dialog = new SelectNdkDialog(path.getPath(), false, true);
            dialog.setModal(true);
            if (dialog.showAndGet() && InstallNdkHyperlink.setNdkPath(project, dialog.getAndroidNdkPath())) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
            }
            return;
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, false, "Loading Remote SDK", true, project);
        RepoManager.RepoLoadedCallback onComplete = packages -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallNdkHyperlink", "lambda$execute$0"));
            }
            Map remotePackages = packages.getRemotePackages();
            RemotePackage ndkPackage = (RemotePackage)remotePackages.get("ndk-bundle");
            if (ndkPackage != null) {
                ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)ndkPackage.getPath()));
                if (dialog != null && dialog.showAndGet()) {
                    GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
                }
                return;
            }
            InstallNdkHyperlink.notifyNdkPackageNotFound(project);
        };
        Runnable onError = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallNdkHyperlink", "lambda$execute$1"));
            }
            InstallNdkHyperlink.notifyNdkPackageNotFound(project);
        };
        sdkManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)progressRunner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    @Nullable
    private static File getNdkPath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallNdkHyperlink", "getNdkPath"));
        }
        try {
            return new LocalProperties(project).getAndroidNdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", project.getName());
            Logger.getInstance(InstallNdkHyperlink.class).info(msg, (Throwable)e);
            return null;
        }
    }

    private static boolean setNdkPath(@NotNull Project project, @Nullable String ndkPath) {
        LocalProperties localProperties;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallNdkHyperlink", "setNdkPath"));
        }
        try {
            localProperties = new LocalProperties(project);
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s':\n%2$s", project.getName(), e.getMessage());
            Messages.showErrorDialog((Project)project, (String)msg, (String)ERROR_TITLE);
            return false;
        }
        try {
            localProperties.setAndroidNdkPath(ndkPath == null ? null : new File(ndkPath));
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save local.properties file of Project '%1$s: %2$s", localProperties.getPropertiesFilePath().getPath(), e.getMessage());
            Messages.showErrorDialog((Project)project, (String)msg, (String)ERROR_TITLE);
            return false;
        }
        return true;
    }

    private static void notifyNdkPackageNotFound(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallNdkHyperlink", "notifyNdkPackageNotFound"));
        }
        Messages.showErrorDialog((Project)project, (String)"Failed to obtain NDK package", (String)ERROR_TITLE);
    }
}

