/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.repo.ExternalRepository;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UpgradeAppenginePluginVersionHyperlink
extends NotificationHyperlink {
    public static final GradleVersion DEFAULT_APPENGINE_PLUGIN_VERSION = GradleVersion.parse((String)"1.9.17");
    @NonNls
    public static final String APPENGINE_PLUGIN_GROUP_ID = "com.google.appengine";
    @NonNls
    public static final String APPENGINE_PLUGIN_ARTIFACT_ID = "gradle-appengine-plugin";
    @NotNull
    private final ArtifactDependencyModel myDependency;
    @NotNull
    private final GradleBuildModel myBuildModel;

    public UpgradeAppenginePluginVersionHyperlink(@NotNull ArtifactDependencyModel dependency, @NotNull GradleBuildModel buildModel) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/project/sync/hyperlink/UpgradeAppenginePluginVersionHyperlink", "<init>"));
        }
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/project/sync/hyperlink/UpgradeAppenginePluginVersionHyperlink", "<init>"));
        }
        super("gradle.plugin.appengine.version.upgrade", AndroidBundle.message("android.gradle.link.appengine.outdated", new Object[0]));
        this.myDependency = dependency;
        this.myBuildModel = buildModel;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/UpgradeAppenginePluginVersionHyperlink", "execute"));
        }
        ExternalRepository repository = (ExternalRepository)ServiceManager.getService(ExternalRepository.class);
        GradleVersion latest = repository.getLatest(APPENGINE_PLUGIN_GROUP_ID, APPENGINE_PLUGIN_ARTIFACT_ID);
        if (latest == null) {
            latest = DEFAULT_APPENGINE_PLUGIN_VERSION;
        }
        this.myDependency.setVersion(latest.toString());
        WriteCommandAction.runWriteCommandAction((Project)project, this.myBuildModel::applyChanges);
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
    }
}

