/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleModelDataService
extends ModuleModelDataService<AndroidModuleModel> {
    @NotNull
    private final AndroidModuleSetup myModuleSetup;
    @NotNull
    private final AndroidModuleValidator.Factory myModuleValidatorFactory;

    public AndroidModuleModelDataService() {
        this(new AndroidModuleSetup(), new AndroidModuleValidator.Factory());
    }

    @VisibleForTesting
    AndroidModuleModelDataService(@NotNull AndroidModuleSetup moduleSetup, @NotNull AndroidModuleValidator.Factory moduleValidatorFactory) {
        if (moduleSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleSetup", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "<init>"));
        }
        if (moduleValidatorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleValidatorFactory", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "<init>"));
        }
        this.myModuleSetup = moduleSetup;
        this.myModuleValidatorFactory = moduleValidatorFactory;
    }

    @NotNull
    public Key<AndroidModuleModel> getTargetDataKey() {
        Key<AndroidModuleModel> key = AndroidProjectKeys.ANDROID_MODEL;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "getTargetDataKey"));
        }
        return key;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<AndroidModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, AndroidModuleModel> modelsByName) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "importData"));
        }
        if (modelsByName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsByName", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "importData"));
        }
        AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(project);
        for (Module module : modelsProvider.getModules()) {
            AndroidModuleModel androidModel = modelsByName.get(module.getName());
            this.setUpModule(module, moduleValidator, modelsProvider, androidModel);
        }
        if (!modelsByName.isEmpty()) {
            moduleValidator.fixAndReportFoundIssues();
        }
    }

    private void setUpModule(@NotNull Module module, @NotNull AndroidModuleValidator moduleValidator, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable AndroidModuleModel androidModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "setUpModule"));
        }
        if (moduleValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleValidator", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "setUpModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/AndroidModuleModelDataService", "setUpModule"));
        }
        this.myModuleSetup.setUpModule(module, modelsProvider, androidModel, null, null);
        if (androidModel != null) {
            moduleValidator.validate(module, androidModel);
        }
    }
}

