/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.ImportedModule;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleDisposer;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDisposalDataService
extends AbstractProjectDataService<ImportedModule, Void> {
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final ModuleDisposer myModuleDisposer;

    public ModuleDisposalDataService(@NotNull IdeInfo ideInfo) {
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleDisposalDataService", "<init>"));
        }
        this(ideInfo, new ModuleDisposer());
    }

    ModuleDisposalDataService(@NotNull IdeInfo ideInfo, @NotNull ModuleDisposer moduleDisposer) {
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleDisposalDataService", "<init>"));
        }
        if (moduleDisposer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDisposer", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleDisposalDataService", "<init>"));
        }
        this.myIdeInfo = ideInfo;
        this.myModuleDisposer = moduleDisposer;
    }

    @NotNull
    public Key<ImportedModule> getTargetDataKey() {
        Key<ImportedModule> key = AndroidProjectKeys.IMPORTED_MODULE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleDisposalDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ImportedModule>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleDisposalDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleDisposalDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleDisposalDataService", "importData"));
        }
        if (toImport.isEmpty() || !this.myIdeInfo.isAndroidStudio() || GradleSyncState.getInstance(project).lastSyncFailedOrHasIssues()) {
            return;
        }
        Module[] modules = modelsProvider.getModules();
        if (modules.length != toImport.size()) {
            HashMap<String, Module> modulesByName = new HashMap<String, Module>();
            for (Module module : modules) {
                modulesByName.put(module.getName(), module);
            }
            for (DataNode dataNode : toImport) {
                ImportedModule importedModule = (ImportedModule)dataNode.getData();
                modulesByName.remove(importedModule.getName());
            }
            ArrayList<Module> modulesToDispose = new ArrayList<Module>(modulesByName.values());
            this.myModuleDisposer.disposeModulesAndMarkImlFilesForDeletion(modulesToDispose, project, modelsProvider);
        }
    }
}

