/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleModelDataService<T extends ModuleModel>
extends AbstractProjectDataService<T, Void> {
    public final void importData(@NotNull Collection<DataNode<T>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            this.onModelsNotFound(modelsProvider);
            return;
        }
        try {
            this.importData(toImport, project, modelsProvider);
        }
        catch (Throwable e) {
            this.getLog().info(String.format("Failed to set up modules in project '%1$s'", project.getName()), e);
            String msg = e.getMessage();
            GradleSyncState.getInstance(project).syncFailed(StringUtil.isNotEmpty((String)msg) ? msg : e.getClass().getCanonicalName());
        }
    }

    protected void onModelsNotFound(@NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "onModelsNotFound"));
        }
    }

    private void importData(final @NotNull Collection<DataNode<T>> toImport, final @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) throws Throwable {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "importData"));
        }
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                if (project.isDisposed()) {
                    return;
                }
                Map modelsByName = ModuleModelDataService.this.indexByModuleName(toImport);
                ModuleModelDataService.this.importData(toImport, project, modelsProvider, modelsByName);
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    protected abstract void importData(@NotNull Collection<DataNode<T>> var1, @NotNull Project var2, @NotNull IdeModifiableModelsProvider var3, @NotNull Map<String, T> var4);

    @NotNull
    private Map<String, T> indexByModuleName(@NotNull Collection<DataNode<T>> dataNodes) {
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "indexByModuleName"));
        }
        if (dataNodes.isEmpty()) {
            Map map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "indexByModuleName"));
            }
            return map;
        }
        HashMap<String, ModuleModel> index = new HashMap<String, ModuleModel>();
        for (DataNode<T> dataNode : dataNodes) {
            ModuleModel model = (ModuleModel)dataNode.getData();
            index.put(model.getModuleName(), model);
        }
        HashMap<String, ModuleModel> hashMap = index;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "indexByModuleName"));
        }
        return hashMap;
    }

    @NotNull
    protected Logger getLog() {
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService", "getLog"));
        }
        return logger;
    }
}

