/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseSyncIssuesReporter {
    BaseSyncIssuesReporter() {
    }

    @NotNull
    SyncMessages getSyncMessages(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/issues/BaseSyncIssuesReporter", "getSyncMessages"));
        }
        SyncMessages syncMessages = SyncMessages.getInstance(module.getProject());
        if (syncMessages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/issues/BaseSyncIssuesReporter", "getSyncMessages"));
        }
        return syncMessages;
    }

    abstract int getSupportedIssueType();

    abstract void report(@NotNull SyncIssue var1, @NotNull Module var2, @Nullable VirtualFile var3);

    @NotNull
    static MessageType getMessageType(@NotNull SyncIssue syncIssue) {
        if (syncIssue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssue", "com/android/tools/idea/gradle/project/sync/issues/BaseSyncIssuesReporter", "getMessageType"));
        }
        MessageType messageType = syncIssue.getSeverity() == 2 ? MessageType.ERROR : MessageType.WARNING;
        if (messageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/issues/BaseSyncIssuesReporter", "getMessageType"));
        }
        return messageType;
    }
}

