/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.JavaModuleSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class JavaModuleSetup {
    private final JavaModuleSetupStep[] mySetupSteps;

    public JavaModuleSetup() {
        this(JavaModuleSetupStep.getExtensions());
    }

    @VisibleForTesting
    JavaModuleSetup(JavaModuleSetupStep[] setupSteps) {
        this.mySetupSteps = setupSteps;
    }

    public void setUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull JavaModuleModel javaModuleModel, SyncAction.ModuleModels models, ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/JavaModuleSetup", "setUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/JavaModuleSetup", "setUpModule"));
        }
        if (javaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModuleModel", "com/android/tools/idea/gradle/project/sync/setup/module/JavaModuleSetup", "setUpModule"));
        }
        if (javaModuleModel.isAndroidModuleWithoutVariants()) {
            SyncMessages messages = SyncMessages.getInstance(module.getProject());
            String[] text = new String[]{String.format("The module '%1$s' is an Android project without build variants, and cannot be built.", module.getName()), "Please fix the module's configuration in the build.gradle file and sync the project again."};
            messages.report(new SyncMessage("Project Structure Issues", MessageType.ERROR, text));
            JavaModuleSetup.cleanUpAndroidModuleWithoutVariants(module, ideModelsProvider);
            return;
        }
        for (JavaModuleSetupStep step : this.mySetupSteps) {
            if (indicator != null) {
                step.displayDescription(module, indicator);
            }
            step.setUpModule(module, ideModelsProvider, javaModuleModel, models, indicator);
        }
    }

    private static void cleanUpAndroidModuleWithoutVariants(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/JavaModuleSetup", "cleanUpAndroidModuleWithoutVariants"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/JavaModuleSetup", "cleanUpAndroidModuleWithoutVariants"));
        }
        Facets.removeAllFacets(ideModelsProvider.getModifiableFacetModel(module), AndroidFacet.ID);
        ModifiableRootModel rootModel = ideModelsProvider.getModifiableRootModel(module);
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            contentEntry.clearSourceFolders();
            contentEntry.clearExcludeFolders();
        }
    }
}

