/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ContentEntriesSetup;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

class AndroidContentEntriesSetup
extends ContentEntriesSetup {
    @NotNull
    private final AndroidModuleModel myAndroidModel;
    private final boolean myHasNativeModel;

    private AndroidContentEntriesSetup(@NotNull AndroidModuleModel androidModel, @NotNull ModifiableRootModel moduleModel, boolean hasNativeModel) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "<init>"));
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "<init>"));
        }
        super(moduleModel);
        this.myAndroidModel = androidModel;
        this.myHasNativeModel = hasNativeModel;
    }

    @Override
    public void execute(@NotNull List<ContentEntry> contentEntries) {
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "execute"));
        }
        Variant selectedVariant = this.myAndroidModel.getSelectedVariant();
        AndroidArtifact mainArtifact = selectedVariant.getMainArtifact();
        this.addSourceFolders((BaseArtifact)mainArtifact, contentEntries, false);
        for (BaseArtifact artifact : AndroidModuleModel.getTestArtifacts(selectedVariant)) {
            this.addSourceFolders(artifact, contentEntries, true);
        }
        for (String flavorName : selectedVariant.getProductFlavors()) {
            ProductFlavorContainer flavor = this.myAndroidModel.findProductFlavor(flavorName);
            if (flavor == null) continue;
            this.addSourceFolder(flavor, contentEntries);
        }
        String buildTypeName = selectedVariant.getBuildType();
        BuildTypeContainer buildTypeContainer = this.myAndroidModel.findBuildType(buildTypeName);
        if (buildTypeContainer != null) {
            this.addSourceFolder(buildTypeContainer.getSourceProvider(), contentEntries, false);
            Collection<SourceProvider> testSourceProviders = this.myAndroidModel.getTestSourceProviders(buildTypeContainer.getExtraSourceProviders());
            for (SourceProvider testSourceProvider : testSourceProviders) {
                this.addSourceFolder(testSourceProvider, contentEntries, true);
            }
        }
        ProductFlavorContainer defaultConfig = this.getAndroidProject().getDefaultConfig();
        this.addSourceFolder(defaultConfig, contentEntries);
        this.addExcludedOutputFolders(contentEntries);
        this.addOrphans();
    }

    private void addSourceFolders(@NotNull BaseArtifact artifact, @NotNull List<ContentEntry> contentEntries, boolean isTest) {
        SourceProvider multiFlavorSourceProvider;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addSourceFolders"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addSourceFolders"));
        }
        this.addGeneratedSourceFolders(artifact, contentEntries, isTest);
        SourceProvider variantSourceProvider = artifact.getVariantSourceProvider();
        if (variantSourceProvider != null) {
            this.addSourceFolder(variantSourceProvider, contentEntries, isTest);
        }
        if ((multiFlavorSourceProvider = artifact.getMultiFlavorSourceProvider()) != null) {
            this.addSourceFolder(multiFlavorSourceProvider, contentEntries, isTest);
        }
    }

    private void addGeneratedSourceFolders(@NotNull BaseArtifact artifact, @NotNull List<ContentEntry> contentEntries, boolean isTest) {
        Collection<File> generatedSourceFolders;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addGeneratedSourceFolders"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addGeneratedSourceFolders"));
        }
        JpsModuleSourceRootType sourceType = AndroidContentEntriesSetup.getSourceType(isTest);
        GradleVersion modelVersion = this.myAndroidModel.getModelVersion();
        if ((artifact instanceof AndroidArtifact || modelVersion != null && modelVersion.compareIgnoringQualifiers("1.2") >= 0) && (generatedSourceFolders = GradleUtil.getGeneratedSourceFolders(artifact)) != null) {
            this.addSourceFolders(generatedSourceFolders, contentEntries, sourceType, true);
        }
        if (artifact instanceof AndroidArtifact) {
            sourceType = AndroidContentEntriesSetup.getResourceSourceType(isTest);
            AndroidArtifact androidArtifact = (AndroidArtifact)artifact;
            this.addSourceFolders(androidArtifact.getGeneratedResourceFolders(), contentEntries, sourceType, true);
        }
    }

    private void addSourceFolder(@NotNull ProductFlavorContainer flavor, @NotNull List<ContentEntry> contentEntries) {
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addSourceFolder"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addSourceFolder"));
        }
        this.addSourceFolder(flavor.getSourceProvider(), contentEntries, false);
        Collection<SourceProvider> testSourceProviders = this.myAndroidModel.getTestSourceProviders(flavor.getExtraSourceProviders());
        for (SourceProvider sourceProvider : testSourceProviders) {
            this.addSourceFolder(sourceProvider, contentEntries, true);
        }
    }

    private void addSourceFolder(@NotNull SourceProvider sourceProvider, @NotNull List<ContentEntry> contentEntries, boolean isTest) {
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addSourceFolder"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addSourceFolder"));
        }
        JpsModuleSourceRootType sourceType = AndroidContentEntriesSetup.getResourceSourceType(isTest);
        this.addSourceFolders(sourceProvider.getResDirectories(), contentEntries, sourceType, false);
        this.addSourceFolders(sourceProvider.getResourcesDirectories(), contentEntries, sourceType, false);
        this.addSourceFolders(sourceProvider.getAssetsDirectories(), contentEntries, sourceType, false);
        sourceType = AndroidContentEntriesSetup.getSourceType(isTest);
        this.addSourceFolders(sourceProvider.getAidlDirectories(), contentEntries, sourceType, false);
        this.addSourceFolders(sourceProvider.getJavaDirectories(), contentEntries, sourceType, false);
        if (this.myHasNativeModel) {
            this.addSourceFolders(sourceProvider.getCDirectories(), contentEntries, sourceType, false);
            this.addSourceFolders(sourceProvider.getCppDirectories(), contentEntries, sourceType, false);
        }
        this.addSourceFolders(sourceProvider.getRenderscriptDirectories(), contentEntries, sourceType, false);
        if (this.myAndroidModel.getFeatures().isShadersSupported()) {
            this.addSourceFolders(sourceProvider.getShadersDirectories(), contentEntries, sourceType, false);
        }
    }

    @NotNull
    private static JpsModuleSourceRootType getResourceSourceType(boolean isTest) {
        JavaResourceRootType javaResourceRootType = isTest ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
        if (javaResourceRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "getResourceSourceType"));
        }
        return javaResourceRootType;
    }

    @NotNull
    private static JpsModuleSourceRootType getSourceType(boolean isTest) {
        JavaSourceRootType javaSourceRootType = isTest ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        if (javaSourceRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "getSourceType"));
        }
        return javaSourceRootType;
    }

    private void addSourceFolders(@NotNull Collection<File> folderPaths, @NotNull List<ContentEntry> contentEntries, @NotNull JpsModuleSourceRootType type, boolean generated) {
        if (folderPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPaths", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addSourceFolders"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addSourceFolders"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addSourceFolders"));
        }
        for (File folderPath : folderPaths) {
            if (generated && !this.isGeneratedAtCorrectLocation(folderPath)) {
                this.myAndroidModel.registerExtraGeneratedSourceFolder(folderPath);
            }
            this.addSourceFolder(folderPath, contentEntries, type, generated);
        }
    }

    private boolean isGeneratedAtCorrectLocation(@NotNull File folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "isGeneratedAtCorrectLocation"));
        }
        File generatedFolderPath = new File(this.getAndroidProject().getBuildFolder(), "generated");
        return FileUtil.isAncestor((File)generatedFolderPath, (File)folderPath, (boolean)false);
    }

    private void addExcludedOutputFolders(@NotNull List<ContentEntry> contentEntries) {
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "addExcludedOutputFolders"));
        }
        File buildFolderPath = this.getAndroidProject().getBuildFolder();
        ContentEntry parentContentEntry = FilePaths.findParentContentEntry(buildFolderPath, contentEntries);
        if (parentContentEntry != null) {
            List<File> excludedFolderPaths = this.myAndroidModel.getExcludedFolderPaths();
            for (File folderPath : excludedFolderPaths) {
                this.addExcludedFolder(parentContentEntry, folderPath);
            }
        }
    }

    @NotNull
    private AndroidProject getAndroidProject() {
        AndroidProject androidProject = this.myAndroidModel.getAndroidProject();
        if (androidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup", "getAndroidProject"));
        }
        return androidProject;
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        AndroidContentEntriesSetup create(@NotNull AndroidModuleModel androidModel, @NotNull ModifiableRootModel moduleModel, boolean hasNativeModel) {
            if (androidModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup$Factory", "create"));
            }
            if (moduleModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup$Factory", "create"));
            }
            AndroidContentEntriesSetup androidContentEntriesSetup = new AndroidContentEntriesSetup(androidModel, moduleModel, hasNativeModel);
            if (androidContentEntriesSetup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidContentEntriesSetup$Factory", "create"));
            }
            return androidContentEntriesSetup;
        }
    }
}

