/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.project.sync.setup.module.SyncLibraryRegistry;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ModuleDependenciesSetup;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class AndroidModuleDependenciesSetup
extends ModuleDependenciesSetup {
    @NotNull
    private final LibraryFilePaths myLibraryFilePaths;

    AndroidModuleDependenciesSetup(@NotNull LibraryFilePaths libraryFilePaths) {
        if (libraryFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFilePaths", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "<init>"));
        }
        this.myLibraryFilePaths = libraryFilePaths;
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File artifactPath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (artifactPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPath", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        this.setUpLibraryDependency(module, modelsProvider, libraryName, scope, artifactPath, new File[]{artifactPath}, ArrayUtilRt.EMPTY_FILE_ARRAY);
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File artifactPath, @NotNull File[] binaryPaths, @NotNull File[] documentationPaths) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (artifactPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPath", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (binaryPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryPaths", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (documentationPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentationPaths", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        boolean newLibrary = false;
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library == null) {
            library = modelsProvider.createLibrary(libraryName);
            newLibrary = true;
        } else {
            SyncLibraryRegistry registry = SyncLibraryRegistry.getInstance(module.getProject());
            registry.markAsUsed(library, binaryPaths);
        }
        if (newLibrary) {
            this.updateLibraryRootTypePaths(library, OrderRootType.CLASSES, modelsProvider, binaryPaths);
            File sourceJarPath = this.myLibraryFilePaths.findSourceJarPath(artifactPath);
            if (sourceJarPath != null) {
                this.updateLibraryRootTypePaths(library, OrderRootType.SOURCES, modelsProvider, sourceJarPath);
            }
            this.updateLibraryRootTypePaths(library, JavadocOrderRootType.getInstance(), modelsProvider, documentationPaths);
            for (File binaryPath : binaryPaths) {
                File annotations;
                String pathName = binaryPath.getName();
                if (pathName.endsWith("res") && pathName.length() > "res".length() && pathName.charAt(pathName.length() - "res".length() - 1) == File.separatorChar) {
                    annotations = new File(pathName.substring(0, pathName.length() - "res".length()), "annotations.zip");
                    if (!annotations.isFile()) continue;
                    this.updateLibraryRootTypePaths(library, AnnotationOrderRootType.getInstance(), modelsProvider, annotations);
                    continue;
                }
                if (!libraryName.startsWith("support-annotations-") || !pathName.endsWith(".jar") || !(annotations = new File(pathName.substring(0, pathName.length() - ".jar".length()) + "-" + "annotations.zip")).isFile()) continue;
                this.updateLibraryRootTypePaths(library, AnnotationOrderRootType.getInstance(), modelsProvider, annotations);
            }
        }
        this.addLibraryAsDependency(library, libraryName, scope, module, modelsProvider);
    }
}

