/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidModuleDependenciesSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupErrors;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModuleSetupStep
extends AndroidModuleSetupStep {
    @NotNull
    private final DependenciesExtractor myDependenciesExtractor;
    @NotNull
    private final AndroidModuleDependenciesSetup myDependenciesSetup;

    @NotNull
    public static DependenciesModuleSetupStep getInstance() {
        for (AndroidModuleSetupStep step : AndroidModuleSetupStep.getExtensions()) {
            if (!(step instanceof DependenciesModuleSetupStep)) continue;
            DependenciesModuleSetupStep dependenciesModuleSetupStep = (DependenciesModuleSetupStep)step;
            if (dependenciesModuleSetupStep == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "getInstance"));
            }
            return dependenciesModuleSetupStep;
        }
        throw new AssertionError((Object)("Unable to find an instance of " + DependenciesModuleSetupStep.class.getSimpleName()));
    }

    public DependenciesModuleSetupStep(@NotNull DependenciesExtractor dependenciesExtractor, @NotNull LibraryFilePaths libraryFilePaths) {
        if (dependenciesExtractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesExtractor", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "<init>"));
        }
        if (libraryFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFilePaths", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "<init>"));
        }
        this(dependenciesExtractor, new AndroidModuleDependenciesSetup(libraryFilePaths));
    }

    @VisibleForTesting
    DependenciesModuleSetupStep(@NotNull DependenciesExtractor dependenciesExtractor, @NotNull AndroidModuleDependenciesSetup dependenciesSetup) {
        if (dependenciesExtractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesExtractor", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "<init>"));
        }
        if (dependenciesSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesSetup", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "<init>"));
        }
        this.myDependenciesExtractor = dependenciesExtractor;
        this.myDependenciesSetup = dependenciesSetup;
    }

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull AndroidModuleModel androidModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "doSetUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "doSetUpModule"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "doSetUpModule"));
        }
        AndroidProject androidProject = androidModel.getAndroidProject();
        DependencySet dependencies = this.myDependenciesExtractor.extractFrom(androidModel);
        for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
            this.updateLibraryDependency(module, ideModelsProvider, libraryDependency, androidProject);
        }
        for (ModuleDependency moduleDependency : dependencies.onModules()) {
            this.updateModuleDependency(module, ideModelsProvider, moduleDependency, androidProject);
        }
        this.addExtraSdkLibrariesAsDependencies(module, ideModelsProvider, androidProject);
        Collection<SyncIssue> syncIssues = androidModel.getSyncIssues();
        if (syncIssues != null) {
            SyncIssuesReporter.getInstance().report(syncIssues, module);
        } else {
            Collection collection = androidProject.getUnresolvedDependencies();
            UnresolvedDependenciesReporter.getInstance().report(collection, module);
        }
    }

    private void updateModuleDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleDependency dependency, @NotNull AndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "updateModuleDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "updateModuleDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "updateModuleDependency"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "updateModuleDependency"));
        }
        Module moduleDependency = dependency.getModule(modelsProvider);
        LibraryDependency compiledArtifact = dependency.getBackupDependency();
        if (moduleDependency != null) {
            ModuleOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module).addModuleOrderEntry(moduleDependency);
            orderEntry.setScope(dependency.getScope());
            orderEntry.setExported(true);
            if (compiledArtifact != null) {
                Projects.setModuleCompiledArtifact(moduleDependency, compiledArtifact);
            }
            return;
        }
        DependencySetupErrors dependencySetupErrors = DependencySetupErrors.getInstance(module.getProject());
        String backupName = compiledArtifact != null ? compiledArtifact.getName() : null;
        dependencySetupErrors.addMissingModule(dependency.getGradlePath(), module.getName(), backupName);
        if (compiledArtifact != null) {
            this.updateLibraryDependency(module, modelsProvider, compiledArtifact, androidProject);
        }
    }

    public void updateLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependency dependency, @NotNull AndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "updateLibraryDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "updateLibraryDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "updateLibraryDependency"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "updateLibraryDependency"));
        }
        String name = dependency.getName();
        DependencyScope scope = dependency.getScope();
        this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, scope, dependency.getArtifactPath(), dependency.getPaths(LibraryDependency.PathType.BINARY), dependency.getPaths(LibraryDependency.PathType.DOCUMENTATION));
        File buildFolder = androidProject.getBuildFolder();
        ContentEntry[] contentEntries = modelsProvider.getModifiableRootModel(module).getContentEntries();
        if (contentEntries.length > 0) {
            for (File binaryPath : dependency.getPaths(LibraryDependency.PathType.BINARY)) {
                ContentEntry parentContentEntry;
                File parent = binaryPath.getParentFile();
                if (parent == null || !"jars".equals(parent.getName()) || !FileUtil.isAncestor((File)buildFolder, (File)parent, (boolean)true) || (parentContentEntry = FilePaths.findParentContentEntry(parent, contentEntries)) == null) continue;
                parentContentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(parent));
            }
        }
    }

    private void addExtraSdkLibrariesAsDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidProject androidProject) {
        SdkAdditionalData data;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "addExtraSdkLibrariesAsDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "addExtraSdkLibrariesAsDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "addExtraSdkLibrariesAsDependencies"));
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        Sdk sdk = moduleModel.getSdk();
        assert (sdk != null);
        String suffix = null;
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData != null && (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData) {
            VirtualFile[] androidSdkData = (VirtualFile[])data;
            suffix = androidSdkData.getBuildTargetHashString();
        }
        if (suffix == null) {
            suffix = androidProject.getCompileTarget();
        }
        HashSet currentIdeSdkFilePaths = Sets.newHashSetWithExpectedSize((int)5);
        for (VirtualFile sdkFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            File sdkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile);
            currentIdeSdkFilePaths.add(sdkFilePath.getPath());
        }
        Collection bootClasspath = androidProject.getBootClasspath();
        for (String library : bootClasspath) {
            if (!StringUtil.isNotEmpty((String)library) || currentIdeSdkFilePaths.contains(library)) continue;
            File binaryPath = new File(library);
            String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)library);
            name = name + "-" + suffix;
            this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, DependencyScope.COMPILE, binaryPath);
        }
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Android dependencies setup" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesModuleSetupStep", "getDescription"));
        }
        return "Android dependencies setup";
    }

    @Override
    public boolean invokeOnBuildVariantChange() {
        return true;
    }
}

