/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.sync.setup.module.common.RootSourceFolder;
import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ContentEntriesSetup {
    @NotNull
    private final ModifiableRootModel myModuleModel;
    @NotNull
    private final List<RootSourceFolder> myOrphans;

    protected ContentEntriesSetup(@NotNull ModifiableRootModel moduleModel) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "<init>"));
        }
        this.myOrphans = new ArrayList<RootSourceFolder>();
        this.myModuleModel = moduleModel;
    }

    public static void removeExistingContentEntries(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "removeExistingContentEntries"));
        }
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            rootModel.removeContentEntry(contentEntry);
        }
    }

    public abstract void execute(@NotNull List<ContentEntry> var1);

    protected void addSourceFolder(@NotNull File folderPath, @NotNull Collection<ContentEntry> contentEntries, @NotNull JpsModuleSourceRootType type, boolean generated) {
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "addSourceFolder"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "addSourceFolder"));
        }
        ContentEntry parent = FilePaths.findParentContentEntry(folderPath, contentEntries);
        if (parent == null) {
            this.myOrphans.add(new RootSourceFolder(folderPath, type, generated));
            return;
        }
        ContentEntriesSetup.addSourceFolder(parent, folderPath, type, generated);
    }

    private static void addSourceFolder(@NotNull ContentEntry contentEntry, @NotNull File folderPath, @NotNull JpsModuleSourceRootType type, boolean generated) {
        JpsModuleSourceRoot sourceRoot;
        JpsElement properties;
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "addSourceFolder"));
        }
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "addSourceFolder"));
        }
        String url = FilePaths.pathToIdeaUrl(folderPath);
        SourceFolder sourceFolder = contentEntry.addSourceFolder(url, type);
        if (generated && (properties = (sourceRoot = sourceFolder.getJpsElement()).getProperties()) instanceof JavaSourceRootProperties) {
            ((JavaSourceRootProperties)properties).setForGeneratedSources(true);
        }
    }

    protected boolean addExcludedFolder(@NotNull ContentEntry contentEntry, @NotNull File folderPath) {
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "addExcludedFolder"));
        }
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "addExcludedFolder"));
        }
        if (!FilePaths.isPathInContentEntry(folderPath, contentEntry)) {
            return false;
        }
        contentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(folderPath));
        return true;
    }

    protected void addOrphans() {
        for (RootSourceFolder orphan : this.myOrphans) {
            File path = orphan.getPath();
            ContentEntry contentEntry = this.myModuleModel.addContentEntry(FilePaths.pathToIdeaUrl(path));
            ContentEntriesSetup.addSourceFolder(contentEntry, path, orphan.getType(), orphan.isGenerated());
        }
    }

    @NotNull
    protected Module getModule() {
        Module module = this.myModuleModel.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup", "getModule"));
        }
        return module;
    }
}

