/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependency
extends Dependency {
    @NotNull
    private final String myGradlePath;
    @Nullable
    private LibraryDependency myBackupDependency;

    @VisibleForTesting
    public ModuleDependency(@NotNull String gradlePath, @NotNull DependencyScope scope) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/ModuleDependency", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/ModuleDependency", "<init>"));
        }
        super(scope);
        this.myGradlePath = gradlePath;
    }

    @Nullable
    public Module getModule(@NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/ModuleDependency", "getModule"));
        }
        for (Module module : modelsProvider.getModules()) {
            GradleFacet gradleFacet = Facets.findFacet(module, modelsProvider, GradleFacet.getFacetTypeId());
            if (gradleFacet == null || !this.hasEqualPath(gradleFacet)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    public Module getModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/ModuleDependency", "getModule"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null || !this.hasEqualPath(gradleFacet)) continue;
            return module;
        }
        return null;
    }

    private boolean hasEqualPath(@NotNull GradleFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/ModuleDependency", "hasEqualPath"));
        }
        String gradlePath = ((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH;
        return StringUtil.isNotEmpty((String)gradlePath) && gradlePath.equals(this.getGradlePath());
    }

    @NotNull
    public String getGradlePath() {
        String string = this.myGradlePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/ModuleDependency", "getGradlePath"));
        }
        return string;
    }

    @Nullable
    public LibraryDependency getBackupDependency() {
        return this.myBackupDependency;
    }

    @VisibleForTesting
    public void setBackupDependency(@Nullable LibraryDependency backupDependency) {
        this.myBackupDependency = backupDependency;
        this.updateBackupDependencyScope();
    }

    @Override
    void setScope(@NotNull DependencyScope scope) throws IllegalArgumentException {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/dependency/ModuleDependency", "setScope"));
        }
        super.setScope(scope);
        this.updateBackupDependencyScope();
    }

    private void updateBackupDependencyScope() {
        if (this.myBackupDependency != null) {
            this.myBackupDependency.setScope(this.getScope());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[gradlePath=" + this.myGradlePath + ", scope=" + this.getScope() + ", backUpDependency=" + this.myBackupDependency + "]";
    }
}

