/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.java;

import com.android.tools.idea.gradle.project.sync.setup.module.SyncLibraryRegistry;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ModuleDependenciesSetup;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaModuleDependenciesSetup
extends ModuleDependenciesSetup {
    JavaModuleDependenciesSetup() {
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File binaryPath, @Nullable File sourcePath, @Nullable File documentationPath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        if (binaryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryPath", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaModuleDependenciesSetup", "setUpLibraryDependency"));
        }
        boolean newLibrary = false;
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library == null) {
            library = modelsProvider.createLibrary(libraryName);
            newLibrary = true;
        } else {
            SyncLibraryRegistry registry = SyncLibraryRegistry.getInstance(module.getProject());
            registry.markAsUsed(library, binaryPath);
        }
        if (newLibrary) {
            this.updateLibraryRootPath(library, OrderRootType.CLASSES, modelsProvider, binaryPath);
            this.updateLibraryRootPath(library, OrderRootType.SOURCES, modelsProvider, sourcePath);
            this.updateLibraryRootPath(library, JavadocOrderRootType.getInstance(), modelsProvider, documentationPath);
        }
        this.addLibraryAsDependency(library, libraryName, scope, module, modelsProvider);
    }

    private void updateLibraryRootPath(@NotNull Library library, @NotNull OrderRootType rootType, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable File path) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaModuleDependenciesSetup", "updateLibraryRootPath"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaModuleDependenciesSetup", "updateLibraryRootPath"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaModuleDependenciesSetup", "updateLibraryRootPath"));
        }
        if (path != null) {
            this.updateLibraryRootTypePaths(library, rootType, modelsProvider, path);
        }
    }
}

