/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.android.DependenciesModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureCleanupStep
extends ProjectCleanupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;
    @NotNull
    private final DependenciesExtractor myDependenciesExtractor;
    @NotNull
    private final DependenciesModuleSetupStep myDependenciesModuleSetupStep;

    public ProjectStructureCleanupStep(@NotNull AndroidSdks androidSdks, @NotNull DependenciesExtractor dependenciesExtractor) {
        if (androidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdks", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "<init>"));
        }
        if (dependenciesExtractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesExtractor", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "<init>"));
        }
        this(androidSdks, dependenciesExtractor, DependenciesModuleSetupStep.getInstance());
    }

    @VisibleForTesting
    ProjectStructureCleanupStep(@NotNull AndroidSdks androidSdks, @NotNull DependenciesExtractor dependenciesExtractor, @NotNull DependenciesModuleSetupStep dependenciesModuleSetupStep) {
        if (androidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdks", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "<init>"));
        }
        if (dependenciesExtractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesExtractor", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "<init>"));
        }
        if (dependenciesModuleSetupStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesModuleSetupStep", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "<init>"));
        }
        this.myAndroidSdks = androidSdks;
        this.myDependenciesExtractor = dependenciesExtractor;
        this.myDependenciesModuleSetupStep = dependenciesModuleSetupStep;
    }

    @Override
    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "cleanUpProject"));
        }
        if (ideModifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModifiableModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "cleanUpProject"));
        }
        HashSet<Sdk> androidSdks = new HashSet<Sdk>();
        for (Module module : ideModifiableModelsProvider.getModules()) {
            ModifiableRootModel rootModel = ideModifiableModelsProvider.getModifiableRootModel(module);
            this.adjustInterModuleDependencies(module, ideModifiableModelsProvider);
            Sdk sdk = rootModel.getSdk();
            if (sdk != null) {
                if (!this.myAndroidSdks.isAndroidSdk(sdk)) continue;
                androidSdks.add(sdk);
                continue;
            }
            NativeAndroidProject nativeAndroidProject = GradleUtil.getNativeAndroidProject(module);
            if (nativeAndroidProject != null) continue;
            Sdk jdk = IdeSdks.getInstance().getJdk();
            rootModel.setSdk(jdk);
        }
        for (Sdk sdk : androidSdks) {
            this.myAndroidSdks.refreshLibrariesIn(sdk);
        }
    }

    private void adjustInterModuleDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "adjustInterModuleDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "adjustInterModuleDependencies"));
        }
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        if (androidProject == null) {
            return;
        }
        this.updateAarDependencies(module, modelsProvider, androidProject);
    }

    private void updateAarDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "updateAarDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "updateAarDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "updateAarDependencies"));
        }
        ModifiableRootModel modifiableModel = modelsProvider.getModifiableRootModel(module);
        for (Module dependency : modifiableModel.getModuleDependencies()) {
            this.updateTransitiveDependencies(module, modelsProvider, androidProject, dependency);
        }
    }

    private void updateTransitiveDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull AndroidProject androidProject, @Nullable Module dependency) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "updateTransitiveDependencies"));
        }
        if (ideModifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModifiableModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "updateTransitiveDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep", "updateTransitiveDependencies"));
        }
        if (dependency == null) {
            return;
        }
        JavaFacet javaFacet = JavaFacet.getInstance(dependency);
        if (javaFacet != null && ((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
            return;
        }
        AndroidProject dependencyAndroidProject = GradleUtil.getAndroidProject(dependency);
        if (dependencyAndroidProject != null) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(dependency);
            if (androidModel != null) {
                DependencySet dependencies = this.myDependenciesExtractor.extractFrom(androidModel);
                for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
                    this.myDependenciesModuleSetupStep.updateLibraryDependency(module, ideModifiableModelsProvider, libraryDependency, androidModel.getAndroidProject());
                }
                Project project = module.getProject();
                for (ModuleDependency moduleDependency : dependencies.onModules()) {
                    Module module1 = moduleDependency.getModule(project);
                    this.updateTransitiveDependencies(module, ideModifiableModelsProvider, androidProject, module1);
                }
            }
        } else {
            LibraryDependency backup = Projects.getModuleCompiledArtifact(dependency);
            if (backup != null) {
                this.myDependenciesModuleSetupStep.updateLibraryDependency(module, ideModifiableModelsProvider, backup, androidProject);
            }
        }
    }
}

