/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class IssuesRenderer {
    @NotNull
    public String render(@NotNull Collection<PsIssue> issues) {
        if (issues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issues", "com/android/tools/idea/gradle/structure/configurables/issues/IssuesRenderer", "render"));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><body><ol>");
        for (PsIssue issue : issues) {
            buffer.append("<li>").append(issue.getPath().toText(PsPath.TexType.HTML)).append(": ").append(issue.getText());
            PsPath quickFixPath = issue.getQuickFixPath();
            if (quickFixPath != null) {
                buffer.append(" ").append(quickFixPath.toText(PsPath.TexType.HTML));
            }
            buffer.append("</li>");
        }
        buffer.append("</ul></body></html>");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/issues/IssuesRenderer", "render"));
        }
        return string;
    }
}

