/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.idea.gradle.structure.dependencies.AbstractAddDependenciesDialog;
import com.android.tools.idea.gradle.structure.dependencies.AbstractDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.dependencies.LibraryDependenciesForm;
import com.android.tools.idea.gradle.structure.dependencies.android.AndroidDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.dependency.PsNewDependencyScopes;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddLibraryDependencyDialog
extends AbstractAddDependenciesDialog {
    @NotNull
    public static final String TITLE = "Add Library Dependency";
    private LibraryDependenciesForm myLibraryDependenciesForm;

    public AddLibraryDependencyDialog(@NotNull PsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog", "<init>"));
        }
        super(module);
        this.setTitle(TITLE);
    }

    @Override
    public void addNewDependencies() {
        String library = this.myLibraryDependenciesForm.getSelectedLibrary();
        assert (library != null);
        AbstractDependencyScopesPanel scopesPanel = this.getScopesPanel();
        List<String> scopesNames = scopesPanel.getSelectedScopeNames();
        PsModule module = this.getModule();
        if (module instanceof PsAndroidModule) {
            PsNewDependencyScopes newScopes = ((AndroidDependencyScopesPanel)scopesPanel).getNewScopes();
            assert (newScopes != null);
            ((PsAndroidModule)module).addLibraryDependency(library, newScopes, scopesNames);
        } else if (module instanceof PsJavaModule) {
            ((PsJavaModule)module).addLibraryDependency(library, scopesNames);
        }
    }

    @Override
    @NotNull
    protected String getSplitterProportionKey() {
        if ("psd.add.library.dependency.main.horizontal.splitter.proportion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog", "getSplitterProportionKey"));
        }
        return "psd.add.library.dependency.main.horizontal.splitter.proportion";
    }

    @Override
    @NotNull
    protected JComponent getDependencySelectionView() {
        if (this.myLibraryDependenciesForm == null) {
            this.myLibraryDependenciesForm = new LibraryDependenciesForm(this.getModule());
        }
        JPanel jPanel = this.myLibraryDependenciesForm.getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog", "getDependencySelectionView"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected String getInstructions() {
        if ("Use the form below to find the library to add. This form uses the repositories specified in  the project's build files (e.g. JCenter, Maven Central, etc.)" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog", "getInstructions"));
        }
        return "Use the form below to find the library to add. This form uses the repositories specified in  the project's build files (e.g. JCenter, Maven Central, etc.)";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        if ("psd.add.library.dependency.panel.dimension" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog", "getDimensionServiceKey"));
        }
        return "psd.add.library.dependency.panel.dimension";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myLibraryDependenciesForm != null ? this.myLibraryDependenciesForm.getPreferredFocusedComponent() : null;
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.myLibraryDependenciesForm != null) {
            Disposer.dispose((Disposable)this.myLibraryDependenciesForm);
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        List<Exception> searchErrors = this.myLibraryDependenciesForm.getSearchErrors();
        if (!searchErrors.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            searchErrors.forEach(e -> buffer.append(AddLibraryDependencyDialog.getErrorMessage(e)).append("\n"));
            return new ValidationInfo(buffer.toString(), this.myLibraryDependenciesForm.getPreferredFocusedComponent());
        }
        String selectedLibrary = this.myLibraryDependenciesForm.getSelectedLibrary();
        if (StringUtil.isEmpty((String)selectedLibrary)) {
            return new ValidationInfo("Please specify the library to add as dependency", this.myLibraryDependenciesForm.getPreferredFocusedComponent());
        }
        PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(selectedLibrary);
        PsModule module = this.getModule();
        if (spec != null && module instanceof PsAndroidModule) {
            PsAndroidModule androidModule = (PsAndroidModule)module;
            Ref found = new Ref((Object)false);
            androidModule.forEachDeclaredDependency(dependency -> {
                if (dependency instanceof PsLibraryAndroidDependency) {
                    PsLibraryAndroidDependency libraryDependency = (PsLibraryAndroidDependency)dependency;
                    PsArtifactDependencySpec resolvedSpec = libraryDependency.getResolvedSpec();
                    if (Objects.equals(spec.group, resolvedSpec.group) && Objects.equals(spec.name, resolvedSpec.name)) {
                        found.set((Object)true);
                    }
                }
            });
            if (((Boolean)found.get()).booleanValue()) {
                String msg = String.format("Library '%1$s' is already a dependency", spec.name);
                return new ValidationInfo(msg, this.myLibraryDependenciesForm.getPreferredFocusedComponent());
            }
        }
        return this.getScopesPanel().validateInput();
    }

    @NotNull
    private static String getErrorMessage(@NotNull Exception error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog", "getErrorMessage"));
        }
        if (error instanceof UnknownHostException) {
            String string = "Failed to connect to host '" + error.getMessage() + "'. Please check your Internet connection.";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog", "getErrorMessage"));
            }
            return string;
        }
        String msg = error.getMessage();
        if (StringUtil.isNotEmpty((String)msg)) {
            String string = msg;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog", "getErrorMessage"));
            }
            return string;
        }
        String string = error.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog", "getErrorMessage"));
        }
        return string;
    }
}

