/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactRepositorySearchForm;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.google.common.base.Strings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibraryDependenciesForm
implements Disposable {
    @NotNull
    private final ArtifactRepositorySearchForm mySearchForm;
    private JPanel myMainPanel;
    private JBLabel myLibraryLabel;
    private JPanel mySearchPanelHost;

    LibraryDependenciesForm(@NotNull PsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/dependencies/LibraryDependenciesForm", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myLibraryLabel.setBorder((Border)BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), IdeBorderFactory.createEmptyBorder((int)2)));
        this.myLibraryLabel.setBackground(UIUtil.getTextFieldBackground());
        this.myLibraryLabel.setText(" ");
        List<ArtifactRepository> repositories = module.getArtifactRepositories();
        this.mySearchForm = new ArtifactRepositorySearchForm(repositories);
        this.mySearchForm.add(selectedLibrary -> {
            String text = StringUtil.isEmpty((String)selectedLibrary) ? " " : selectedLibrary;
            this.myLibraryLabel.setText(text);
        }, this);
        this.mySearchPanelHost.add((Component)this.mySearchForm.getPanel(), "Center");
    }

    @NotNull
    JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.mySearchForm.getPreferredFocusedComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/LibraryDependenciesForm", "getPreferredFocusedComponent"));
        }
        return jComponent;
    }

    @NotNull
    JPanel getPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/LibraryDependenciesForm", "getPanel"));
        }
        return jPanel;
    }

    @Nullable
    String getSelectedLibrary() {
        String text = this.myLibraryLabel.getText().trim();
        return Strings.emptyToNull((String)text);
    }

    @NotNull
    List<Exception> getSearchErrors() {
        List<Exception> list = this.mySearchForm.getSearchErrors();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/dependencies/LibraryDependenciesForm", "getSearchErrors"));
        }
        return list;
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Library:");
        jBLabel2.setDisplayedMnemonic('L');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLibraryLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySearchPanelHost = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jBLabel2.setLabelFor((Component)jBLabel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

