/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.builder.model.MavenCoordinates;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsArtifactDependencySpec {
    @NotNull
    public String name;
    @Nullable
    public String group;
    @Nullable
    public String version;

    @Nullable
    public static PsArtifactDependencySpec create(@NotNull String notation) {
        if (notation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notation", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "create"));
        }
        List segments = Splitter.on((String)":").trimResults().omitEmptyStrings().splitToList((CharSequence)notation);
        int segmentCount = segments.size();
        if (segmentCount > 0) {
            String lastSegment = (String)(segments = Lists.newArrayList((Iterable)segments)).remove(segmentCount - 1);
            int indexOfAt = lastSegment.indexOf(64);
            if (indexOfAt != -1) {
                lastSegment = lastSegment.substring(0, indexOfAt);
            }
            segments.add(lastSegment);
            segmentCount = segments.size();
            String group = null;
            String name = null;
            String version = null;
            if (segmentCount == 1) {
                name = (String)segments.get(0);
            } else if (segmentCount == 2) {
                if (!lastSegment.isEmpty() && Character.isDigit(lastSegment.charAt(0))) {
                    name = (String)segments.get(0);
                    version = lastSegment;
                } else {
                    group = (String)segments.get(0);
                    name = (String)segments.get(1);
                }
            } else if (segmentCount == 3 || segmentCount == 4) {
                group = (String)segments.get(0);
                name = (String)segments.get(1);
                version = (String)segments.get(2);
            }
            if (StringUtil.isNotEmpty((String)name)) {
                return new PsArtifactDependencySpec(name, group, version);
            }
        }
        return null;
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull ArtifactDependencyModel dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "create"));
        }
        PsArtifactDependencySpec psArtifactDependencySpec = new PsArtifactDependencySpec(dependency.name().value(), (String)dependency.group().value(), (String)dependency.version().value());
        if (psArtifactDependencySpec == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "create"));
        }
        return psArtifactDependencySpec;
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull MavenCoordinates coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "create"));
        }
        PsArtifactDependencySpec psArtifactDependencySpec = new PsArtifactDependencySpec(coordinates.getArtifactId(), coordinates.getGroupId(), coordinates.getVersion());
        if (psArtifactDependencySpec == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "create"));
        }
        return psArtifactDependencySpec;
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull GradleModuleVersion moduleVersion) {
        if (moduleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleVersion", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "create"));
        }
        PsArtifactDependencySpec psArtifactDependencySpec = new PsArtifactDependencySpec(moduleVersion.getName(), moduleVersion.getGroup(), moduleVersion.getVersion());
        if (psArtifactDependencySpec == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "create"));
        }
        return psArtifactDependencySpec;
    }

    public PsArtifactDependencySpec(@NotNull String name, @Nullable String group, @Nullable String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "<init>"));
        }
        this.name = name;
        this.group = Strings.emptyToNull((String)group);
        this.version = Strings.emptyToNull((String)version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsArtifactDependencySpec that = (PsArtifactDependencySpec)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.group, this.version});
    }

    public String toString() {
        return this.compactNotation();
    }

    @NotNull
    public String compactNotation() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.group, this.name, this.version});
        String string = Joiner.on((String)":").skipNulls().join((Iterable)segments);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "compactNotation"));
        }
        return string;
    }

    @NotNull
    public String getDisplayText() {
        boolean showGroupId = PsUISettings.getInstance().DECLARED_DEPENDENCIES_SHOW_GROUP_ID;
        StringBuilder text = new StringBuilder();
        if (showGroupId && StringUtil.isNotEmpty((String)this.group)) {
            text.append(this.group).append(":");
        }
        text.append(this.name);
        if (StringUtil.isNotEmpty((String)this.version)) {
            text.append(":").append(this.version);
        }
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec", "getDisplayText"));
        }
        return string;
    }
}

