/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Charsets;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesFiles {
    private PropertiesFiles() {
    }

    @NotNull
    public static Properties getProperties(@NotNull File filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/gradle/util/PropertiesFiles", "getProperties"));
        }
        if (filePath.isDirectory()) {
            throw new IllegalArgumentException(String.format("The path '%1$s' belongs to a directory!", filePath.getPath()));
        }
        if (!filePath.exists()) {
            Properties properties = new Properties();
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/PropertiesFiles", "getProperties"));
            }
            return properties;
        }
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(filePath)), Charsets.UTF_8);){
            properties.load(reader);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/PropertiesFiles", "getProperties"));
        }
        return properties2;
    }

    public static void savePropertiesToFile(@NotNull Properties properties, @NotNull File filePath, @Nullable String comments) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/util/PropertiesFiles", "savePropertiesToFile"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/gradle/util/PropertiesFiles", "savePropertiesToFile"));
        }
        FileUtilRt.createParentDirs((File)filePath);
        try (FileOutputStream out = new FileOutputStream(filePath);){
            properties.store(out, comments);
        }
    }
}

