/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.checks.ObjectAnimatorDetector;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintAnimatorKeepInspection
extends AndroidLintInspectionBase {
    public AndroidLintAnimatorKeepInspection() {
        super(AndroidBundle.message("android.lint.inspections.animator.keep", new Object[0]), ObjectAnimatorDetector.MISSING_KEEP);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, final @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection", "getQuickFixes"));
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new AndroidLintQuickFix(){

            @Override
            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                PsiAnnotation annotation;
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection$1", "apply"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection$1", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection$1", "apply"));
                }
                if (!ObjectAnimatorDetector.isAddKeepErrorMessage((String)message, (TextFormat)TextFormat.RAW)) {
                    return;
                }
                PsiModifierListOwner container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class);
                if (container == null) {
                    return;
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)container)) {
                    return;
                }
                PsiModifierList modifierList = container.getModifierList();
                if (modifierList != null && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])new String[]{"android.support.annotation.Keep"})) == null) {
                    Project project = startElement.getProject();
                    new AddAnnotationFix("android.support.annotation.Keep", container, new String[0]).invoke(project, null, container.getContainingFile());
                }
            }

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection$1", "isApplicable"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection$1", "isApplicable"));
                }
                if (contextType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection$1", "isApplicable"));
                }
                return true;
            }

            @Override
            @NotNull
            public String getName() {
                if ("Annotate with @Keep" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection$1", "getName"));
                }
                return "Annotate with @Keep";
            }
        }};
        if (androidLintQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintAnimatorKeepInspection", "getQuickFixes"));
        }
        return androidLintQuickFixArray;
    }
}

