/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.LintOptions;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.lint.DomPsiParser;
import com.android.tools.idea.lint.LintIdeIssueRegistry;
import com.android.tools.idea.lint.LintIdeJavaParser;
import com.android.tools.idea.lint.LintIdeUtils;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.State;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintIdeClient
extends LintClient
implements Disposable {
    protected static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.LintIdeClient");
    protected com.intellij.openapi.project.Project myProject;
    @Nullable
    protected Map<Project, Module> myModuleMap;
    @Nullable
    private static volatile String ourSystemPath;
    private static List<Issue> ourReportedCustomIssues;

    public LintIdeClient(com.intellij.openapi.project.Project project) {
        super("studio");
        this.myProject = project;
    }

    public static LintIdeClient forBatch(@NotNull com.intellij.openapi.project.Project project, @NotNull Map<Issue, Map<File, List<ProblemData>>> problemMap, @NotNull AnalysisScope scope, @NotNull List<Issue> issues) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/lint/LintIdeClient", "forBatch"));
        }
        if (problemMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemMap", "com/android/tools/idea/lint/LintIdeClient", "forBatch"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/lint/LintIdeClient", "forBatch"));
        }
        if (issues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issues", "com/android/tools/idea/lint/LintIdeClient", "forBatch"));
        }
        return new BatchLintClient(project, problemMap, scope, issues);
    }

    @Nullable
    public static ApiLookup getApiLookup(@NotNull com.intellij.openapi.project.Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/lint/LintIdeClient", "getApiLookup"));
        }
        return ApiLookup.get((LintClient)new LintIdeClient(project));
    }

    public void runReadAction(Runnable runnable) {
        ApplicationManager.getApplication().runReadAction(runnable);
    }

    public static LintIdeClient forEditor(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/lint/LintIdeClient", "forEditor"));
        }
        return new EditorLintClient(state);
    }

    @Nullable
    protected Module findModuleForLintProject(@NotNull com.intellij.openapi.project.Project project, @NotNull Project lintProject) {
        Module module;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/lint/LintIdeClient", "findModuleForLintProject"));
        }
        if (lintProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lintProject", "com/android/tools/idea/lint/LintIdeClient", "findModuleForLintProject"));
        }
        if (this.myModuleMap != null && (module = this.myModuleMap.get(lintProject)) != null) {
            return module;
        }
        File dir = lintProject.getDir();
        VirtualFile vDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
        return vDir != null ? ModuleUtilCore.findModuleForFile((VirtualFile)vDir, (com.intellij.openapi.project.Project)project) : null;
    }

    void setModuleMap(@Nullable Map<Project, Module> moduleMap) {
        this.myModuleMap = moduleMap;
    }

    public Configuration getConfiguration(Project project, final @Nullable LintDriver driver) {
        AndroidProject model;
        if (project.isGradleProject() && project.isAndroidProject() && !project.isLibrary() && (model = project.getGradleProjectModel()) != null) {
            try {
                LintOptions lintOptions = model.getLintOptions();
                final Map overrides = lintOptions.getSeverityOverrides();
                if (overrides != null && !overrides.isEmpty()) {
                    return new DefaultConfiguration(this, project, null){

                        public Severity getSeverity(Issue issue) {
                            Integer severity = (Integer)overrides.get(issue.getId());
                            if (severity != null) {
                                switch (severity) {
                                    case 1: {
                                        return Severity.FATAL;
                                    }
                                    case 2: {
                                        return Severity.ERROR;
                                    }
                                    case 3: {
                                        return Severity.WARNING;
                                    }
                                    case 4: {
                                        return Severity.INFORMATIONAL;
                                    }
                                }
                                return Severity.IGNORE;
                            }
                            if (!(LintIdeClient.this.getIssues().contains(issue) || driver != null && driver.isCustomIssue(issue))) {
                                return Severity.IGNORE;
                            }
                            return super.getSeverity(issue);
                        }
                    };
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return new DefaultConfiguration(this, project, null){

            public boolean isEnabled(Issue issue) {
                if (LintIdeClient.this.getIssues().contains(issue) && super.isEnabled(issue)) {
                    return true;
                }
                return driver != null && driver.isCustomIssue(issue) || issue == IssueRegistry.BASELINE || issue == IssueRegistry.CANCELLED;
            }
        };
    }

    public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format) {
        assert (false) : message;
    }

    protected List<Issue> getIssues() {
        return Collections.emptyList();
    }

    @Nullable
    protected Module getModule() {
        return null;
    }

    protected void reportSecondary(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format) {
        Location secondary = location.getSecondary();
        if (secondary != null && secondary.isVisible()) {
            String secondaryMessage = secondary.getMessage();
            if (secondaryMessage != null) {
                message = secondary.isSelfExplanatory() ? secondaryMessage : message + " (" + secondaryMessage + ")";
            }
            this.report(context, issue, severity, secondary, message, format);
        }
    }

    public void log(Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
        if (severity == Severity.ERROR || severity == Severity.FATAL) {
            if (format != null) {
                LOG.error(String.format(format, args), exception);
            } else if (exception != null) {
                LOG.error(exception);
            }
        } else if (severity == Severity.WARNING) {
            if (format != null) {
                LOG.warn(String.format(format, args), exception);
            } else if (exception != null) {
                LOG.warn(exception);
            }
        } else if (format != null) {
            LOG.info(String.format(format, args), exception);
        } else if (exception != null) {
            LOG.info(exception);
        }
    }

    public XmlParser getXmlParser() {
        return new DomPsiParser(this);
    }

    @Nullable
    public JavaParser getJavaParser(@Nullable Project project) {
        return new LintIdeJavaParser(this, this.myProject);
    }

    public List<File> getJavaClassFolders(Project project) {
        return Collections.emptyList();
    }

    public List<File> getJavaLibraries(Project project, boolean includeProvided) {
        return Collections.emptyList();
    }

    public List<File> getTestLibraries(Project project) {
        return Collections.emptyList();
    }

    public String readFile(final File file) {
        final VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile == null) {
            LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
            return "";
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                PsiFile psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)LintIdeClient.this.myProject).findFile(vFile);
                if (psiFile == null) {
                    LOG.info("Cannot find file " + file.getPath() + " in the PSI");
                    return null;
                }
                return psiFile.getText();
            }
        });
    }

    public void dispose() {
    }

    @Nullable
    public File getSdkHome() {
        File home;
        String path;
        Sdk moduleSdk;
        Module module = this.getModule();
        if (module != null && (moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && moduleSdk.getSdkType() instanceof AndroidSdkType && (path = moduleSdk.getHomePath()) != null && (home = new File(path)).exists()) {
            return home;
        }
        File sdkHome = super.getSdkHome();
        if (sdkHome != null) {
            return sdkHome;
        }
        for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
            File home2;
            String path2;
            Sdk moduleSdk2 = ModuleRootManager.getInstance((Module)m).getSdk();
            if (moduleSdk2 == null || !(moduleSdk2.getSdkType() instanceof AndroidSdkType) || (path2 = moduleSdk2.getHomePath()) == null || !(home2 = new File(path2)).exists()) continue;
            return home2;
        }
        return IdeSdks.getInstance().getAndroidSdkPath();
    }

    @Nullable
    public AndroidSdkHandler getSdk() {
        if (this.sdk == null) {
            Module module = this.getModule();
            AndroidSdkHandler localSdk = LintIdeClient.getLocalSdk(module);
            if (localSdk != null) {
                this.sdk = localSdk;
            } else {
                for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
                    localSdk = LintIdeClient.getLocalSdk(m);
                    if (localSdk == null) continue;
                    this.sdk = localSdk;
                    break;
                }
                if (localSdk == null) {
                    this.sdk = super.getSdk();
                }
            }
        }
        return this.sdk;
    }

    @Nullable
    private static AndroidSdkHandler getLocalSdk(@Nullable Module module) {
        AndroidSdkData sdkData;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (sdkData = facet.getSdkData()) != null) {
            return sdkData.getSdkHandler();
        }
        return null;
    }

    @Nullable
    public BuildToolInfo getBuildTools(Project project) {
        GradleVersion version;
        AndroidModuleModel model;
        Module module;
        if (project.isGradleProject() && (module = this.getModule()) != null && (model = AndroidModuleModel.get(module)) != null && (version = model.getModelVersion()) != null && version.isAtLeast(2, 1, 0)) {
            String buildToolsVersion = model.getAndroidProject().getBuildToolsVersion();
            AndroidSdkHandler sdk = this.getSdk();
            if (sdk != null) {
                try {
                    Revision revision = Revision.parseRevision((String)buildToolsVersion);
                    BuildToolInfo buildToolInfo = sdk.getBuildToolInfo(revision, this.getRepositoryLogger());
                    if (buildToolInfo != null) {
                        return buildToolInfo;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return super.getBuildTools(project);
    }

    @Nullable
    public String getClientRevision() {
        return ApplicationInfoEx.getInstanceEx().getFullVersion();
    }

    public boolean isGradleProject(Project project) {
        Module module = this.getModule();
        if (module != null) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            return facet != null && facet.requiresAndroidModel();
        }
        return AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel();
    }

    @Nullable
    public File findResource(String relativePath) {
        File file;
        File top = this.getSdkHome();
        if (top != null && (file = new File(top, relativePath)).exists()) {
            return file;
        }
        return null;
    }

    @Nullable
    public File getCacheDir(boolean create) {
        String path = ourSystemPath != null ? ourSystemPath : (ourSystemPath = PathUtil.getCanonicalPath((String)PathManager.getSystemPath()));
        File lint = new File(path, "lint");
        if (create && !lint.exists()) {
            lint.mkdirs();
        }
        return lint;
    }

    public boolean isProjectDirectory(File dir) {
        return new File(dir, ".idea").exists();
    }

    private static void recordCustomIssue(Issue issue) {
        if (ourReportedCustomIssues == null) {
            ourReportedCustomIssues = Lists.newArrayList();
        } else if (ourReportedCustomIssues.contains(issue)) {
            return;
        }
        ourReportedCustomIssues.add(issue);
    }

    @Nullable
    public static Issue findCustomIssue(String errorMessage) {
        int end;
        int begin;
        if (ourReportedCustomIssues != null && (begin = errorMessage.lastIndexOf(91)) < (end = errorMessage.lastIndexOf(93)) && begin != -1) {
            String id = errorMessage.substring(begin + 1, end);
            for (Issue issue : ourReportedCustomIssues) {
                if (!id.equals(issue.getId())) continue;
                return issue;
            }
        }
        return null;
    }

    public boolean checkForSuppressComments() {
        return false;
    }

    public boolean supportsProjectResources() {
        return true;
    }

    @Nullable
    public AbstractResourceRepository getResourceRepository(Project project, boolean includeModuleDependencies, boolean includeLibraries) {
        AndroidFacet facet;
        Module module = this.findModuleForLintProject(this.myProject, project);
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            if (includeLibraries) {
                return facet.getAppResources(true);
            }
            if (includeModuleDependencies) {
                return facet.getProjectResources(true);
            }
            return facet.getModuleResources(true);
        }
        return null;
    }

    @Nullable
    public URLConnection openConnection(URL url) throws IOException {
        return HttpConfigurable.getInstance().openConnection(url.toExternalForm());
    }

    public ClassLoader createUrlClassLoader(URL[] urls, ClassLoader parent) {
        return UrlClassLoader.build().parent(parent).urls(urls).get();
    }

    public Location.Handle createResourceItemHandle(ResourceItem item) {
        XmlTag tag = LocalResourceRepository.getItemTag(this.myProject, item);
        if (tag != null) {
            ResourceFile source = (ResourceFile)item.getSource();
            assert (source != null) : item;
            return new LocationHandle(source.getFile(), (XmlElement)tag);
        }
        return super.createResourceItemHandle(item);
    }

    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        ResourceVisibilityLookup.Provider provider;
        AppResourceRepository appResources;
        Module module = this.getModule();
        if (module != null && (appResources = AppResourceRepository.getAppResources(module, true)) != null && (provider = appResources.getResourceVisibilityProvider()) != null) {
            return provider;
        }
        return super.getResourceVisibilityProvider();
    }

    private static class LocationHandle
    implements Location.Handle,
    Computable<Location> {
        private final File myFile;
        private final XmlElement myNode;
        private Object myClientData;

        public LocationHandle(File file, XmlElement node) {
            this.myFile = file;
            this.myNode = node;
        }

        public Location resolve() {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (Location)ApplicationManager.getApplication().runReadAction((Computable)this);
            }
            TextRange textRange = this.myNode.getTextRange();
            if (this.myNode instanceof XmlTag) {
                String tag = ((XmlTag)this.myNode).getName();
                int index = this.myNode.getText().indexOf(tag);
                if (index != -1) {
                    int start = textRange.getStartOffset() + index;
                    textRange = new TextRange(start, start + tag.length());
                }
            }
            DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
            DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
            return Location.create((File)this.myFile, (Position)start, (Position)end);
        }

        public Location compute() {
            return this.resolve();
        }

        public void setClientData(@Nullable Object clientData) {
            this.myClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.myClientData;
        }
    }

    private static class BatchLintClient
    extends LintIdeClient {
        private final Map<Issue, Map<File, List<ProblemData>>> myProblemMap;
        private final AnalysisScope myScope;
        private final List<Issue> myIssues;

        public BatchLintClient(@NotNull com.intellij.openapi.project.Project project, @NotNull Map<Issue, Map<File, List<ProblemData>>> problemMap, @NotNull AnalysisScope scope, @NotNull List<Issue> issues) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/lint/LintIdeClient$BatchLintClient", "<init>"));
            }
            if (problemMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemMap", "com/android/tools/idea/lint/LintIdeClient$BatchLintClient", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/lint/LintIdeClient$BatchLintClient", "<init>"));
            }
            if (issues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issues", "com/android/tools/idea/lint/LintIdeClient$BatchLintClient", "<init>"));
            }
            super(project);
            this.myProblemMap = problemMap;
            this.myScope = scope;
            this.myIssues = issues;
        }

        @Override
        @Nullable
        protected Module getModule() {
            return null;
        }

        @Override
        protected List<Issue> getIssues() {
            return this.myIssues;
        }

        @Override
        public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format) {
            boolean inScope;
            Module module;
            VirtualFile vFile = null;
            File file = null;
            if (location != null) {
                file = location.getFile();
                vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            } else if (context.getProject() != null && (module = this.findModuleForLintProject(this.myProject, context.getProject())) != null) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                VirtualFile virtualFile = vFile = facet != null ? AndroidRootUtil.getPrimaryManifestFile(facet) : null;
                if (vFile != null) {
                    file = new File(vFile.getPath());
                }
            }
            boolean bl = inScope = vFile != null && this.myScope.contains(vFile);
            if (!inScope && vFile != null && vFile.isDirectory()) {
                Module module2;
                if (this.myScope.getScopeType() == 1) {
                    inScope = true;
                } else if ((this.myScope.getScopeType() == 4 || this.myScope.getScopeType() == 7) && (module2 = this.findModuleForLintProject(this.myProject, context.getProject())) != null && this.myScope.containsModule(module2)) {
                    inScope = true;
                }
            }
            if (inScope) {
                List<ProblemData> problemList;
                if (context.getDriver().isCustomIssue(issue)) {
                    message = message + " [" + issue.getId() + "]";
                    LintIdeClient.recordCustomIssue(issue);
                    issue = Severity.WARNING.compareTo((Enum)severity) <= 0 ? LintIdeIssueRegistry.CUSTOM_WARNING : LintIdeIssueRegistry.CUSTOM_ERROR;
                }
                file = new File(PathUtil.getCanonicalPath((String)file.getPath()));
                HashMap file2ProblemList = this.myProblemMap.get(issue);
                if (file2ProblemList == null) {
                    file2ProblemList = new HashMap();
                    this.myProblemMap.put(issue, (Map<File, List<ProblemData>>)file2ProblemList);
                }
                if ((problemList = file2ProblemList.get(file)) == null) {
                    problemList = new ArrayList<ProblemData>();
                    file2ProblemList.put(file, problemList);
                }
                TextRange textRange = TextRange.EMPTY_RANGE;
                if (location != null) {
                    Position start = location.getStart();
                    Position end = location.getEnd();
                    if (start != null && end != null && start.getOffset() <= end.getOffset()) {
                        textRange = new TextRange(start.getOffset(), end.getOffset());
                    }
                }
                Severity configuredSeverity = severity != issue.getDefaultSeverity() ? severity : null;
                message = format.convertTo(message, TextFormat.RAW);
                problemList.add(new ProblemData(issue, message, textRange, configuredSeverity));
                if (location != null && location.getSecondary() != null) {
                    this.reportSecondary(context, issue, severity, location, message, format);
                }
            }
        }

        public List<File> getJavaSourceFolders(Project project) {
            Module module = this.findModuleForLintProject(this.myProject, project);
            if (module == null) {
                return Collections.emptyList();
            }
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            ArrayList<File> result = new ArrayList<File>(sourceRoots.length);
            for (VirtualFile root : sourceRoots) {
                result.add(new File(root.getPath()));
            }
            return result;
        }

        public List<File> getResourceFolders(Project project) {
            AndroidFacet facet;
            Module module = this.findModuleForLintProject(this.myProject, project);
            if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
                return LintIdeUtils.getResourceDirectories(facet);
            }
            return super.getResourceFolders(project);
        }
    }

    private static class EditorLintClient
    extends LintIdeClient {
        private final State myState;

        public EditorLintClient(@NotNull State state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/lint/LintIdeClient$EditorLintClient", "<init>"));
            }
            super(state.getModule().getProject());
            this.myState = state;
        }

        @Override
        @Nullable
        protected Module getModule() {
            return this.myState.getModule();
        }

        @Override
        protected List<Issue> getIssues() {
            return this.myState.getIssues();
        }

        @Override
        public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format) {
            if (location != null) {
                Location secondary;
                File file = location.getFile();
                VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                if (context.getDriver().isCustomIssue(issue)) {
                    message = message + " [" + issue.getId() + "]";
                    LintIdeClient.recordCustomIssue(issue);
                    Issue issue2 = issue = Severity.WARNING.compareTo((Enum)severity) <= 0 ? LintIdeIssueRegistry.CUSTOM_WARNING : LintIdeIssueRegistry.CUSTOM_ERROR;
                }
                if (this.myState.getMainFile().equals(vFile)) {
                    Position start = location.getStart();
                    Position end = location.getEnd();
                    TextRange textRange = start != null && end != null && start.getOffset() <= end.getOffset() ? new TextRange(start.getOffset(), end.getOffset()) : TextRange.EMPTY_RANGE;
                    Severity configuredSeverity = severity != issue.getDefaultSeverity() ? severity : null;
                    message = format.convertTo(message, TextFormat.RAW);
                    this.myState.getProblems().add(new ProblemData(issue, message, textRange, configuredSeverity));
                }
                if ((secondary = location.getSecondary()) != null && this.myState.getMainFile().equals(LocalFileSystem.getInstance().findFileByIoFile(secondary.getFile()))) {
                    this.reportSecondary(context, issue, severity, location, message, format);
                }
            }
        }

        @Override
        @NotNull
        public String readFile(File file) {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) {
                String string;
                try {
                    string = Files.toString((File)file, (Charset)Charsets.UTF_8);
                }
                catch (IOException ioe) {
                    LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/LintIdeClient$EditorLintClient", "readFile"));
                    }
                    return "";
                }
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/LintIdeClient$EditorLintClient", "readFile"));
                }
                return string;
            }
            String content = this.getFileContent(vFile);
            if (content == null) {
                LOG.info("Cannot find file " + file.getPath() + " in the PSI");
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/LintIdeClient$EditorLintClient", "readFile"));
                }
                return "";
            }
            String string = content;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/LintIdeClient$EditorLintClient", "readFile"));
            }
            return string;
        }

        @Nullable
        private String getFileContent(final VirtualFile vFile) {
            if (Comparing.equal((Object)this.myState.getMainFile(), (Object)vFile)) {
                return this.myState.getMainFileContent();
            }
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    Module module = myState.getModule();
                    com.intellij.openapi.project.Project project = module.getProject();
                    if (project.isDisposed()) {
                        return null;
                    }
                    PsiFile psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)project).findFile(vFile);
                    if (psiFile == null) {
                        return null;
                    }
                    Document document = PsiDocumentManager.getInstance((com.intellij.openapi.project.Project)project).getDocument(psiFile);
                    if (document != null) {
                        DocumentListener listener = new DocumentListener(){

                            public void documentChanged(DocumentEvent event) {
                                myState.markDirty();
                            }
                        };
                        document.addDocumentListener(listener, (Disposable)this);
                    }
                    return psiFile.getText();
                }
            });
        }

        public List<File> getJavaSourceFolders(Project project) {
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)this.myState.getModule()).getSourceRoots(false);
            ArrayList<File> result = new ArrayList<File>(sourceRoots.length);
            for (VirtualFile root : sourceRoots) {
                result.add(new File(root.getPath()));
            }
            return result;
        }

        public List<File> getResourceFolders(Project project) {
            AndroidFacet facet = AndroidFacet.getInstance(this.myState.getModule());
            if (facet != null) {
                return LintIdeUtils.getResourceDirectories(facet);
            }
            return super.getResourceFolders(project);
        }
    }
}

