/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.lint.AndroidLintMissingConstraintsInspection;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.lint.checks.ConstraintLayoutDetector;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeConstraintLayoutFix
implements AndroidLintQuickFix {
    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/UpgradeConstraintLayoutFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/UpgradeConstraintLayoutFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lint/UpgradeConstraintLayoutFix", "apply"));
        }
        Module module = AndroidPsiUtils.getModuleSafely(startElement);
        UpgradeConstraintLayoutFix.apply(module);
    }

    public static void apply(@Nullable Module module) {
        if (module != null) {
            GradleCoordinate gc;
            StudioSdkUtil.reloadRemoteSdkWithModalProgress();
            AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(AndroidLintMissingConstraintsInspection.class);
            RepoPackage p = SdkMavenRepository.findLatestVersion((GradleCoordinate)ConstraintLayoutDetector.LATEST_KNOWN_VERSION, (AndroidSdkHandler)sdkHandler, (ProgressIndicator)progress);
            if (p != null && (gc = SdkMavenRepository.getCoordinateFromSdkPath((String)p.getPath())) != null) {
                GradleDependencyManager manager = GradleDependencyManager.getInstance(module.getProject());
                manager.updateLibrariesToVersion(module, Collections.singletonList(gc), null);
            }
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/UpgradeConstraintLayoutFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/UpgradeConstraintLayoutFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/lint/UpgradeConstraintLayoutFix", "isApplicable"));
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Upgrade to recommended version" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/UpgradeConstraintLayoutFix", "getName"));
        }
        return "Upgrade to recommended version";
    }
}

