/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.model;

import com.android.tools.idea.monitor.ui.cpu.model.AppTrace;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class TraceDataStore {
    private static TraceDataStore ourInstance;
    private HashMap<String, ArrayList<AppTrace>> traces = new HashMap();

    private TraceDataStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TraceDataStore getInstance() {
        if (ourInstance != null) return ourInstance;
        Class<TraceDataStore> clazz = TraceDataStore.class;
        synchronized (TraceDataStore.class) {
            if (ourInstance != null) return ourInstance;
            ourInstance = new TraceDataStore();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourInstance;
        }
    }

    public void addTrace(@NotNull String projectName, @NotNull AppTrace trace) {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/monitor/ui/cpu/model/TraceDataStore", "addTrace"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/android/tools/idea/monitor/ui/cpu/model/TraceDataStore", "addTrace"));
        }
        ArrayList<AppTrace> projectTraces = this.traces.get(projectName);
        if (projectTraces == null) {
            projectTraces = new ArrayList();
            this.traces.put(projectName, projectTraces);
        }
        projectTraces.add(trace);
    }

    public AppTrace getLastThreadsActivity(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/monitor/ui/cpu/model/TraceDataStore", "getLastThreadsActivity"));
        }
        ArrayList<AppTrace> projectTraces = this.traces.get(projectName);
        if (projectTraces == null || projectTraces.isEmpty()) {
            return null;
        }
        return projectTraces.get(projectTraces.size() - 1);
    }
}

