/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.model;

import com.android.tools.datastore.DataAdapter;
import com.android.tools.idea.monitor.ui.memory.model.AllocationTrackingSample;
import com.android.tools.idea.monitor.ui.memory.view.MemoryProfilerUiManager;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MemoryDataCache {
    static final int UNFINISHED_TIMESTAMP = -1;
    private List<MemoryProfiler.MemoryData.MemorySample> myMemorySamples;
    private List<MemoryProfiler.MemoryData.VmStatsSample> myVmStatsSamples;
    private List<MemoryProfiler.HeapDumpInfo> myHeapDumpInfos;
    private Map<MemoryProfiler.HeapDumpInfo, ByteString> myHeapDumps;
    private List<AllocationTrackingSample> myAllocationTrackingSamples;
    private EventDispatcher<MemoryProfilerUiManager.MemoryEventListener> myMemoryEventDispatcher;

    public MemoryDataCache(@NotNull EventDispatcher<MemoryProfilerUiManager.MemoryEventListener> dispatcher) {
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "<init>"));
        }
        this.myMemorySamples = Collections.synchronizedList(new ArrayList());
        this.myVmStatsSamples = Collections.synchronizedList(new ArrayList());
        this.myHeapDumpInfos = Collections.synchronizedList(new ArrayList());
        this.myHeapDumps = new HashMap<MemoryProfiler.HeapDumpInfo, ByteString>();
        this.myAllocationTrackingSamples = Collections.synchronizedList(new ArrayList());
        this.myMemoryEventDispatcher = dispatcher;
    }

    public void appendMemorySamples(@NotNull List<MemoryProfiler.MemoryData.MemorySample> memorySamples) {
        if (memorySamples == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memorySamples", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "appendMemorySamples"));
        }
        this.myMemorySamples.addAll(memorySamples);
    }

    public void appendVmStatsSamples(@NotNull List<MemoryProfiler.MemoryData.VmStatsSample> vmStatsSamples) {
        if (vmStatsSamples == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmStatsSamples", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "appendVmStatsSamples"));
        }
        this.myVmStatsSamples.addAll(vmStatsSamples);
    }

    public void appendHeapDumpInfo(@NotNull MemoryProfiler.HeapDumpInfo heapDumpInfo) {
        if (heapDumpInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heapDumpInfo", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "appendHeapDumpInfo"));
        }
        this.myHeapDumpInfos.add(heapDumpInfo);
    }

    public void addPulledHeapDumpData(@NotNull MemoryProfiler.HeapDumpInfo heapDumpInfo, @NotNull ByteString heapDumpFile) {
        if (heapDumpInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heapDumpInfo", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "addPulledHeapDumpData"));
        }
        if (heapDumpFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heapDumpFile", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "addPulledHeapDumpData"));
        }
        this.myHeapDumps.put(heapDumpInfo, heapDumpFile);
        ((MemoryProfilerUiManager.MemoryEventListener)this.myMemoryEventDispatcher.getMulticaster()).newHeapDumpInfosRetrieved(heapDumpInfo);
    }

    public void executeOnHeapDumpData(@NotNull BiConsumer<MemoryProfiler.HeapDumpInfo, ByteString> biConsumer) {
        if (biConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "biConsumer", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "executeOnHeapDumpData"));
        }
        this.myHeapDumps.forEach(biConsumer);
    }

    public void addAllocationTrackingData(@NotNull AllocationTrackingSample allocationTrackingSample) {
        if (allocationTrackingSample == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allocationTrackingSample", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "addAllocationTrackingData"));
        }
        this.myAllocationTrackingSamples.add(allocationTrackingSample);
        ((MemoryProfilerUiManager.MemoryEventListener)this.myMemoryEventDispatcher.getMulticaster()).newAllocationTrackingInfosRetrieved(allocationTrackingSample);
    }

    public void executeOnAllocationTrackingSamples(@NotNull Consumer<AllocationTrackingSample> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "executeOnAllocationTrackingSamples"));
        }
        this.myAllocationTrackingSamples.forEach(consumer);
    }

    @NotNull
    public MemoryProfiler.MemoryData.MemorySample getMemorySample(int index) {
        MemoryProfiler.MemoryData.MemorySample memorySample = this.myMemorySamples.get(index);
        if (memorySample == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "getMemorySample"));
        }
        return memorySample;
    }

    @NotNull
    public MemoryProfiler.MemoryData.VmStatsSample getVmStatsSample(int index) {
        MemoryProfiler.MemoryData.VmStatsSample vmStatsSample = this.myVmStatsSamples.get(index);
        if (vmStatsSample == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "getVmStatsSample"));
        }
        return vmStatsSample;
    }

    @NotNull
    public MemoryProfiler.HeapDumpInfo getHeapDumpInfo(int index) {
        MemoryProfiler.HeapDumpInfo heapDumpInfo = this.myHeapDumpInfos.get(index);
        if (heapDumpInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "getHeapDumpInfo"));
        }
        return heapDumpInfo;
    }

    @NotNull
    public AllocationTrackingSample getAllocationTrackingSample(int index) {
        AllocationTrackingSample allocationTrackingSample = this.myAllocationTrackingSamples.get(index);
        if (allocationTrackingSample == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "getAllocationTrackingSample"));
        }
        return allocationTrackingSample;
    }

    @NotNull
    public ByteString getHeapDumpData(@NotNull MemoryProfiler.HeapDumpInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "getHeapDumpData"));
        }
        assert (this.myHeapDumps.containsKey(info));
        ByteString byteString = this.myHeapDumps.get(info);
        if (byteString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "getHeapDumpData"));
        }
        return byteString;
    }

    public MemoryProfiler.HeapDumpInfo swapLastHeapDumpInfo(@NotNull MemoryProfiler.HeapDumpInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/monitor/ui/memory/model/MemoryDataCache", "swapLastHeapDumpInfo"));
        }
        int lastIndex = this.getLastHeapDumpIndex();
        MemoryProfiler.HeapDumpInfo result = this.myHeapDumpInfos.get(lastIndex);
        this.myHeapDumpInfos.set(lastIndex, info);
        return result;
    }

    public int getLastHeapDumpIndex() {
        return this.myHeapDumpInfos.size() - 1;
    }

    public int getLatestPriorMemorySampleIndex(long time, boolean leftClosest) {
        int index = Collections.binarySearch(this.myMemorySamples, MemoryProfiler.MemoryData.MemorySample.newBuilder().setTimestamp(time).build(), (left, right) -> {
            long diff = left.getTimestamp() - right.getTimestamp();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        return DataAdapter.convertBinarySearchIndex((int)index, (int)this.myMemorySamples.size(), (boolean)leftClosest);
    }

    public int getLatestPriorVmStatsSampleIndex(long time, boolean leftClosest) {
        int index = Collections.binarySearch(this.myVmStatsSamples, MemoryProfiler.MemoryData.VmStatsSample.newBuilder().setTimestamp(time).build(), (left, right) -> {
            long diff = left.getTimestamp() - right.getTimestamp();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        return DataAdapter.convertBinarySearchIndex((int)index, (int)this.myVmStatsSamples.size(), (boolean)leftClosest);
    }

    public int getLatestPriorHeapDumpInfoIndex(long time, boolean leftClosest) {
        int index = Collections.binarySearch(this.myHeapDumpInfos, MemoryProfiler.HeapDumpInfo.newBuilder().setStartTime(time).build(), (left, right) -> {
            long diff = left.getStartTime() - right.getStartTime();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        return DataAdapter.convertBinarySearchIndex((int)index, (int)this.myHeapDumpInfos.size(), (boolean)leftClosest);
    }

    public int getLatestPriorAllocationTrackingSampleIndex(long time, boolean leftClosest) {
        int index = Collections.binarySearch(this.myAllocationTrackingSamples, new AllocationTrackingSample(time, time, new byte[0]), (left, right) -> {
            long diff = left.getStartTime() - right.getStartTime();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        return DataAdapter.convertBinarySearchIndex((int)index, (int)this.myAllocationTrackingSamples.size(), (boolean)leftClosest);
    }

    public void reset() {
        this.myMemorySamples.clear();
        this.myVmStatsSamples.clear();
        this.myHeapDumpInfos.clear();
        this.myHeapDumps.clear();
        this.myAllocationTrackingSamples.clear();
    }
}

