/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.view;

import com.android.tools.adtui.AccordionLayout;
import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.network.model.HttpDataCache;
import com.android.tools.idea.monitor.ui.network.model.NetworkDataPoller;
import com.android.tools.idea.monitor.ui.network.model.RpcNetworkCaptureModel;
import com.android.tools.idea.monitor.ui.network.view.NetworkCaptureSegment;
import com.android.tools.idea.monitor.ui.network.view.NetworkDetailedView;
import com.android.tools.idea.monitor.ui.network.view.NetworkRadioSegment;
import com.android.tools.idea.monitor.ui.network.view.NetworkSegment;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class NetworkProfilerUiManager
extends BaseProfilerUiManager {
    public static final int NETWORK_CONNECTIVITY_HEIGHT = 40;
    private NetworkRadioSegment myRadioSegment;
    private NetworkCaptureSegment myCaptureSegment;
    private NetworkDetailedView myDetailedView;
    @NotNull
    private final HttpDataCache myDataCache;

    public NetworkProfilerUiManager(@NotNull Range timeCurrentRangeUs, @NotNull Choreographer choreographer, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher, @NotNull Project project) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "<init>"));
        }
        if (choreographer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choreographer", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "<init>"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "<init>"));
        }
        if (eventDispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventDispatcher", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "<init>"));
        }
        super(timeCurrentRangeUs, choreographer, dataStore, eventDispatcher);
        this.myDataCache = new HttpDataCache(this.myDataStore.getDeviceProfilerService().getDevice());
        this.myDetailedView = new NetworkDetailedView(project);
    }

    @Override
    @NotNull
    public Set<Poller> createPollers(int pid) {
        HashSet hashSet = Sets.newHashSet((Object[])new Poller[]{new NetworkDataPoller(this.myDataStore, pid)});
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "createPollers"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    protected BaseSegment createOverviewSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "createOverviewSegment"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "createOverviewSegment"));
        }
        if (eventDispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventDispatcher", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "createOverviewSegment"));
        }
        NetworkSegment networkSegment = new NetworkSegment(timeCurrentRangeUs, dataStore, eventDispatcher);
        if (networkSegment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "createOverviewSegment"));
        }
        return networkSegment;
    }

    @Override
    public void setupDetailedViewUi(@NotNull JPanel toolbar, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "setupDetailedViewUi"));
        }
        if (detailPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailPanel", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "setupDetailedViewUi"));
        }
        super.setupDetailedViewUi(toolbar, detailPanel);
        detailPanel.add((Component)this.myDetailedView, "Center");
    }

    @Override
    public boolean isDetailedViewVerticallySplit() {
        return false;
    }

    @Override
    public void setupExtendedOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "setupExtendedOverviewUi"));
        }
        if (overviewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overviewPanel", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "setupExtendedOverviewUi"));
        }
        super.setupExtendedOverviewUi(toolbar, overviewPanel);
        this.myRadioSegment = new NetworkRadioSegment(this.myTimeCurrentRangeUs, this.myDataStore, (EventDispatcher<ProfilerEventListener>)this.myEventDispatcher);
        this.setupAndRegisterSegment(this.myRadioSegment, 40, 40, 40);
        overviewPanel.add(this.myRadioSegment);
        RpcNetworkCaptureModel captureModel = new RpcNetworkCaptureModel(this.myDataStore.getDeviceProfilerService(), this.myDataCache);
        this.myCaptureSegment = new NetworkCaptureSegment(this.myTimeCurrentRangeUs, captureModel, httpData -> {
            VirtualFile virtualFile;
            String responseFilePath = httpData.getHttpResponsePayloadId();
            File file = !StringUtil.isEmptyOrSpaces((String)responseFilePath) ? this.myDataCache.getFile(responseFilePath) : null;
            VirtualFile virtualFile2 = virtualFile = file != null ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file) : null;
            if (virtualFile != null) {
                this.myDetailedView.showConnectionDetails(virtualFile);
                ((ProfilerEventListener)this.myEventDispatcher.getMulticaster()).profilerExpanded(BaseProfilerUiManager.ProfilerType.NETWORK);
            }
        }, (EventDispatcher<ProfilerEventListener>)this.myEventDispatcher);
        this.setupAndRegisterSegment(this.myCaptureSegment, DEFAULT_MONITOR_MIN_HEIGHT, DEFAULT_MONITOR_PREFERRED_HEIGHT, DEFAULT_MONITOR_MAX_HEIGHT);
        overviewPanel.add(this.myCaptureSegment);
        this.myChoreographer.register((Animatable)this.myCaptureSegment);
        NetworkProfilerUiManager.setSegmentState(overviewPanel, this.myCaptureSegment, AccordionLayout.AccordionState.MAXIMIZE);
    }

    @Override
    public void resetProfiler(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "resetProfiler"));
        }
        if (overviewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overviewPanel", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "resetProfiler"));
        }
        if (detailPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailPanel", "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager", "resetProfiler"));
        }
        super.resetProfiler(toolbar, overviewPanel, detailPanel);
        if (this.myRadioSegment != null) {
            overviewPanel.remove(this.myRadioSegment);
            this.myRadioSegment = null;
        }
        if (this.myCaptureSegment != null) {
            overviewPanel.remove(this.myCaptureSegment);
            this.myChoreographer.unregister((Animatable)this.myCaptureSegment);
            this.myCaptureSegment = null;
        }
        if (this.myDetailedView != null) {
            detailPanel.remove(this.myDetailedView);
        }
    }
}

