/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.navigator.nodes.ExternalBuildFileNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalBuildFilesGroupNode
extends ProjectViewNode<Project> {
    public ExternalBuildFilesGroupNode(@NotNull Project project, @NotNull ViewSettings viewSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/ExternalBuildFilesGroupNode", "<init>"));
        }
        if (viewSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSettings", "com/android/tools/idea/navigator/nodes/ExternalBuildFilesGroupNode", "<init>"));
        }
        super(project, (Object)project, viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/nodes/ExternalBuildFilesGroupNode", "contains"));
        }
        return this.getBuildFilesWithModuleNames().containsKey(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Map<VirtualFile, String> buildFiles = this.getBuildFilesWithModuleNames();
        ArrayList children = Lists.newArrayListWithExpectedSize((int)buildFiles.size());
        for (Map.Entry<VirtualFile, String> buildFileWithModuleName : buildFiles.entrySet()) {
            this.addPsiFile(children, buildFileWithModuleName.getKey(), buildFileWithModuleName.getValue());
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/ExternalBuildFilesGroupNode", "getChildren"));
        }
        return arrayList;
    }

    @NotNull
    private Map<VirtualFile, String> getBuildFilesWithModuleNames() {
        HashMap buildFiles = Maps.newHashMap();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
            if (ndkModuleModel == null) continue;
            for (File file : ndkModuleModel.getAndroidProject().getBuildFiles()) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (virtualFile == null) continue;
                buildFiles.put(virtualFile, module.getName());
            }
        }
        HashMap hashMap = buildFiles;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/ExternalBuildFilesGroupNode", "getBuildFilesWithModuleNames"));
        }
        return hashMap;
    }

    private void addPsiFile(@NotNull List<PsiFileNode> psiFileNodes, @NotNull VirtualFile file, @NotNull String moduleName) {
        if (psiFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileNodes", "com/android/tools/idea/navigator/nodes/ExternalBuildFilesGroupNode", "addPsiFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/nodes/ExternalBuildFilesGroupNode", "addPsiFile"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/navigator/nodes/ExternalBuildFilesGroupNode", "addPsiFile"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile != null) {
            psiFileNodes.add(new ExternalBuildFileNode(this.myProject, psiFile, this.getSettings(), moduleName));
        }
    }

    public int getWeight() {
        return 200;
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText("External Build Files");
        presentation.setIcon(AllIcons.General.ExternalToolsSmall);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "External Build Files";
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

