/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.ChooseApiLevelDialog;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorApiComboBox;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.stats.DistributionService;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FormFactorSdkControls {
    private JBLabel myLabel;
    private FormFactorApiComboBox myMinSdkCombobox;
    private final FormFactor myFormFactor;
    private final int myMinApi;
    private static final ScopedStateStore.Key<String> API_FEEDBACK_KEY = ScopedStateStore.createKey("API Feedback", ScopedStateStore.Scope.STEP, String.class);
    private JBLabel myHelpMeChooseLabel2;
    private HyperlinkLabel myHelpMeChooseLink;
    private final ScopedDataBinder myBinder;
    private JCheckBox myInclusionCheckBox;
    private JPanel myRootPanel;
    private JLabel myNotAvailableLabel;
    private JPanel myStatsPanel;
    private JPanel myLoadingStatsPanel;
    private final Disposable myDisposable;
    private final ScopedStateStore.Key<Boolean> myInclusionKey;
    private JBLabel myStatsLoadFailedLabel;
    private JBLabel myHelpMeChooseLabel1;
    private JCheckBox myInstantAppCheckbox;

    public FormFactorSdkControls(FormFactor formFactor, int minApi, Disposable disposable, ScopedDataBinder binder) {
        this.myFormFactor = formFactor;
        this.myMinApi = minApi;
        this.myBinder = binder;
        this.$$$setupUI$$$();
        this.myInclusionCheckBox.setText(formFactor.toString());
        this.myDisposable = disposable;
        this.myInclusionKey = FormFactorUtils.getInclusionKey(this.myFormFactor);
        this.myHelpMeChooseLabel2.setText(FormFactorSdkControls.getApiHelpText(0, ""));
        this.myHelpMeChooseLink.setHyperlinkText("Help me choose");
        if (this.myFormFactor.baseFormFactor != null) {
            this.myLabel.setVisible(false);
            this.myMinSdkCombobox.setVisible(false);
        }
        if (!this.myFormFactor.equals((Object)FormFactor.MOBILE)) {
            this.myHelpMeChooseLabel1.setVisible(false);
            this.myStatsPanel.setVisible(false);
        }
        this.myMinSdkCombobox.setName(this.myFormFactor.id + ".minSdk");
        this.myStatsLoadFailedLabel.setForeground((Color)JBColor.GRAY);
    }

    public ScopedStateStore.Key<Boolean> getInclusionKey() {
        return this.myInclusionKey;
    }

    public void init(final ScopedStateStore state, Runnable loadComplete) {
        this.myBinder.register(this.myInclusionKey, this.myInclusionCheckBox);
        this.myHelpMeChooseLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                Integer minApiLevel = state.get(FormFactorUtils.getMinApiLevelKey(FormFactor.MOBILE));
                ChooseApiLevelDialog chooseApiLevelDialog = new ChooseApiLevelDialog(null, minApiLevel == null ? 0 : minApiLevel);
                Disposer.register((Disposable)FormFactorSdkControls.this.myDisposable, (Disposable)chooseApiLevelDialog.getDisposable());
                if (chooseApiLevelDialog.showAndGet()) {
                    int selectedApiLevel = chooseApiLevelDialog.getSelectedApiLevel();
                    ScopedDataBinder.setSelectedItem(FormFactorSdkControls.this.myMinSdkCombobox, Integer.toString(selectedApiLevel));
                }
            }
        });
        if (this.myStatsPanel.isVisible()) {
            this.myBinder.register(API_FEEDBACK_KEY, this.myHelpMeChooseLabel2, new ScopedDataBinder.ComponentBinding<String, JBLabel>(){

                @Override
                public void setValue(@Nullable String newValue, @NotNull JBLabel label) {
                    if (label == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/npw/FormFactorSdkControls$2", "setValue"));
                    }
                    JBLabel referenceLabel = label;
                    String referenceString = newValue;
                    ApplicationManager.getApplication().invokeLater(() -> referenceLabel.setText(referenceString));
                }
            });
            this.myBinder.registerValueDeriver(API_FEEDBACK_KEY, new ScopedDataBinder.ValueDeriver<String>(){

                @Override
                @Nullable
                public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                    return 3.makeSetOf(FormFactorUtils.getTargetComboBoxKey(FormFactor.MOBILE));
                }

                @Override
                @Nullable
                public String deriveValue(@NotNull ScopedStateStore state, ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/FormFactorSdkControls$3", "deriveValue"));
                    }
                    FormFactorApiComboBox.AndroidTargetComboBoxItem selectedItem = state.get(FormFactorUtils.getTargetComboBoxKey(FormFactor.MOBILE));
                    String name = Integer.toString(selectedItem == null ? 0 : selectedItem.getApiLevel());
                    if (selectedItem != null && selectedItem.target != null) {
                        name = selectedItem.target.getVersion().getApiString();
                    }
                    return FormFactorSdkControls.getApiHelpText(selectedItem == null || !FormFactorSdkControls.this.myStatsPanel.isVisible() ? 0 : selectedItem.getApiLevel(), name);
                }
            });
        }
        this.myMinSdkCombobox.init(this.myFormFactor, this.myMinApi, loadComplete, () -> {
            this.myInclusionCheckBox.setEnabled(true);
            this.myLabel.setEnabled(true);
            this.myMinSdkCombobox.setEnabled(true);
        }, () -> {
            this.myInclusionCheckBox.setSelected(false);
            this.myNotAvailableLabel.setVisible(true);
        });
        this.myMinSdkCombobox.registerWith(this.myBinder);
        this.myMinSdkCombobox.loadSavedApi();
        if (this.myStatsPanel.isVisible()) {
            DistributionService.getInstance().refresh(() -> ApplicationManager.getApplication().invokeLater(() -> {
                ((CardLayout)this.myStatsPanel.getLayout()).show(this.myStatsPanel, "stats");
                this.myBinder.invokeUpdate(FormFactorUtils.getTargetComboBoxKey(FormFactor.MOBILE));
            }), () -> ApplicationManager.getApplication().invokeLater(() -> {
                ((CardLayout)this.myStatsPanel.getLayout()).show(this.myStatsPanel, "stats");
                this.myBinder.invokeUpdate(FormFactorUtils.getTargetComboBoxKey(FormFactor.MOBILE));
                this.myStatsLoadFailedLabel.setVisible(true);
            }));
        }
        if (this.myFormFactor.equals((Object)FormFactor.MOBILE) && state.getNotNull(WizardConstants.WH_SDK_ENABLED_KEY, false).booleanValue()) {
            this.myBinder.register(WizardConstants.IS_INSTANT_APP_KEY, this.myInstantAppCheckbox);
            this.myInstantAppCheckbox.setVisible(true);
        }
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public void deriveValues(@NotNull ScopedStateStore stateStore, @NotNull Set<ScopedStateStore.Key> modified) {
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStore", "com/android/tools/idea/npw/FormFactorSdkControls", "deriveValues"));
        }
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/android/tools/idea/npw/FormFactorSdkControls", "deriveValues"));
        }
        this.myMinSdkCombobox.deriveValues(stateStore, modified);
    }

    private static String getApiHelpText(int selectedApi, String selectedApiName) {
        float percentage = (float)(DistributionService.getInstance().getSupportedDistributionForApiLevel(selectedApi) * 100.0);
        return String.format(Locale.getDefault(), "<html>By targeting API %1$s and later, your app will run on %2$s of the devices<br>that are active on the Google Play Store.</html>", selectedApiName, percentage < 1.0f ? "&lt; 1%" : String.format(Locale.getDefault(), "approximately <b>%.1f%%</b>", Float.valueOf(percentage)));
    }

    private void createUIComponents() {
        this.myLoadingStatsPanel = new JPanel(new FlowLayout(0));
        AsyncProcessIcon refreshIcon = new AsyncProcessIcon("loading");
        JLabel refreshingLabel = new JLabel("Loading Stats...");
        refreshingLabel.setForeground((Color)JBColor.GRAY);
        this.myLoadingStatsPanel.add((Component)refreshIcon);
        this.myLoadingStatsPanel.add(refreshingLabel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        HyperlinkLabel hyperlinkLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JBLabel jBLabel3;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        FormFactorApiComboBox formFactorApiComboBox;
        JBLabel jBLabel4;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Minimum SDK");
        jBLabel4.setEnabled(false);
        jPanel2.add((Component)jBLabel4, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMinSdkCombobox = formFactorApiComboBox = new FormFactorApiComboBox();
        ((Component)formFactorApiComboBox).setEnabled(false);
        jPanel2.add((Component)formFactorApiComboBox, new GridConstraints(1, 2, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 2, 1, 2, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 1, new Dimension(30, -1), null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myInclusionCheckBox = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(false);
        jCheckBox2.setText("Form factor name");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNotAvailableLabel = jLabel = new JLabel();
        jLabel.setText("(Not Available)");
        ((Component)jLabel).setVisible(false);
        ((Component)jLabel).setEnabled(false);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myHelpMeChooseLabel1 = jBLabel3 = new JBLabel();
        jBLabel3.setText("Lower API levels target more devices, but have fewer features available.");
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 2, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myStatsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 2, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = this.myLoadingStatsPanel;
        jPanel.add((Component)jPanel4, "statsLoading");
        ((CardLayout)jPanel.getLayout()).show(jPanel, "statsLoading");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, "stats");
        this.myHelpMeChooseLabel2 = jBLabel2 = new JBLabel();
        jBLabel2.setText("help me choose");
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.myHelpMeChooseLink = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setVisible(true);
        jPanel5.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myStatsLoadFailedLabel = jBLabel = new JBLabel();
        jBLabel.setText("Stats load failed. Value may be out of date.");
        jBLabel.setVisible(false);
        jPanel5.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myInstantAppCheckbox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setVisible(false);
        jCheckBox.setText("Include Instant App support (preview)");
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 2, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

