/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public final class VectorAsset
extends BaseAsset {
    private static final String ERROR_EMPTY_PREVIEW = "Could not generate a preview";
    private final ObjectProperty<FileType> myFileType;
    private final ObjectProperty<File> myPath;
    private final IntProperty myOpacity;
    private final BoolProperty myAutoMirrored;
    private final IntProperty myOutputWidth;
    private final IntProperty myOutputHeight;

    public VectorAsset(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "<init>"));
        }
        this.myFileType = new ObjectValueProperty<FileType>(FileType.SVG);
        this.myPath = new ObjectValueProperty<File>(new File(System.getProperty("user.home")));
        this.myOpacity = new IntValueProperty(100);
        this.myAutoMirrored = new BoolValueProperty();
        this.myOutputWidth = new IntValueProperty();
        this.myOutputHeight = new IntValueProperty();
        this.type().set(fileType);
    }

    @NotNull
    public static FileType typeFromExtension(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "typeFromExtension"));
        }
        String fullPath = new File(path).getAbsolutePath();
        int index = fullPath.lastIndexOf(46);
        String extension = path.substring(index + 1);
        switch (extension.toLowerCase(Locale.ROOT)) {
            case "svg": {
                FileType fileType = FileType.SVG;
                if (fileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "typeFromExtension"));
                }
                return fileType;
            }
            case "psd": {
                FileType fileType = FileType.LAYERED_IMAGE;
                if (fileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "typeFromExtension"));
                }
                return fileType;
            }
        }
        FileType fileType = FileType.VECTOR_DRAWABLE;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "typeFromExtension"));
        }
        return fileType;
    }

    @NotNull
    public ObjectProperty<FileType> type() {
        ObjectProperty<FileType> objectProperty = this.myFileType;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "type"));
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<File> path() {
        ObjectProperty<File> objectProperty = this.myPath;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "path"));
        }
        return objectProperty;
    }

    @NotNull
    public IntProperty opacity() {
        IntProperty intProperty = this.myOpacity;
        if (intProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "opacity"));
        }
        return intProperty;
    }

    @NotNull
    public BoolProperty autoMirrored() {
        BoolProperty boolProperty = this.myAutoMirrored;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "autoMirrored"));
        }
        return boolProperty;
    }

    @NotNull
    public IntProperty outputWidth() {
        IntProperty intProperty = this.myOutputWidth;
        if (intProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "outputWidth"));
        }
        return intProperty;
    }

    @NotNull
    public IntProperty outputHeight() {
        IntProperty intProperty = this.myOutputHeight;
        if (intProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "outputHeight"));
        }
        return intProperty;
    }

    @NotNull
    public ParseResult parse(int previewWidth, boolean allowPropertyOverride) {
        ParseResult parseResult = this.tryParse(previewWidth, allowPropertyOverride);
        if (parseResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "parse"));
        }
        return parseResult;
    }

    @NotNull
    public ParseResult parse() {
        ParseResult parseResult = this.parse(0, true);
        if (parseResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "parse"));
        }
        return parseResult;
    }

    @Override
    @NotNull
    protected BufferedImage createAsImage(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "createAsImage"));
        }
        BufferedImage bufferedImage = this.parse().getImage();
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "createAsImage"));
        }
        return bufferedImage;
    }

    @NotNull
    private ParseResult tryParse(int previewWidth, boolean allowPropertyOverride) {
        Document vdDocument;
        StringBuilder errorBuffer = new StringBuilder();
        File path = (File)this.myPath.get();
        if (!path.exists() || path.isDirectory()) {
            ParseResult parseResult = ParseResult.INVALID;
            if (parseResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "tryParse"));
            }
            return parseResult;
        }
        String xmlFileContent = null;
        FileType fileType = (FileType)((Object)this.myFileType.get());
        if (fileType.equals((Object)FileType.SVG)) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            String errorLog = Svg2Vector.parseSvgToXml((File)path, (OutputStream)outStream);
            errorBuffer.append(errorLog);
            xmlFileContent = ((Object)outStream).toString();
        } else if (fileType.equals((Object)FileType.LAYERED_IMAGE)) {
            try {
                xmlFileContent = new LayeredImageConverter().toVectorDrawableXml(path);
            }
            catch (IOException e) {
                errorBuffer.append(e.getMessage());
            }
        } else {
            try {
                xmlFileContent = Files.toString((File)path, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                errorBuffer.append(e.getMessage());
            }
        }
        BufferedImage image = null;
        int originalWidth = 0;
        int originalHeight = 0;
        if (xmlFileContent != null && (vdDocument = VdPreview.parseVdStringIntoDocument((String)xmlFileContent, (StringBuilder)errorBuffer)) != null) {
            String overriddenXml;
            VdPreview.SourceSize vdOriginalSize = VdPreview.getVdOriginalSize((Document)vdDocument);
            originalWidth = vdOriginalSize.getWidth();
            originalHeight = vdOriginalSize.getHeight();
            if (allowPropertyOverride && (overriddenXml = this.overrideXmlFileContent(vdDocument, vdOriginalSize, errorBuffer)) != null) {
                xmlFileContent = overriddenXml;
            }
            if (previewWidth <= 0) {
                previewWidth = (Integer)this.myOutputWidth.get() > 0 ? (Integer)this.myOutputWidth.get() : originalWidth;
            }
            VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createSizeFromWidth((int)previewWidth);
            image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)imageTargetSize, (String)xmlFileContent, (StringBuilder)errorBuffer);
        }
        if (image == null) {
            errorBuffer.insert(0, "Could not generate a preview\n");
            ParseResult parseResult = new ParseResult(errorBuffer.toString());
            if (parseResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "tryParse"));
            }
            return parseResult;
        }
        ParseResult parseResult = new ParseResult(errorBuffer.toString(), image, originalWidth, originalHeight, xmlFileContent);
        if (parseResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "tryParse"));
        }
        return parseResult;
    }

    @Nullable
    private String overrideXmlFileContent(@NotNull Document vdDocument, @NotNull VdPreview.SourceSize vdOriginalSize, @NotNull StringBuilder errorBuffer) {
        if (vdDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vdDocument", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "overrideXmlFileContent"));
        }
        if (vdOriginalSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vdOriginalSize", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "overrideXmlFileContent"));
        }
        if (errorBuffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorBuffer", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset", "overrideXmlFileContent"));
        }
        int finalWidth = vdOriginalSize.getWidth();
        int finalHeight = vdOriginalSize.getHeight();
        Integer outputWidth = (Integer)this.myOutputWidth.get();
        Integer outputHeight = (Integer)this.myOutputHeight.get();
        if (outputWidth > 0) {
            finalWidth = outputWidth;
        }
        if (outputHeight > 0) {
            finalHeight = outputHeight;
        }
        finalWidth = Math.max(1, finalWidth);
        finalHeight = Math.max(1, finalHeight);
        finalWidth = Math.min(4096, finalWidth);
        finalHeight = Math.min(4096, finalHeight);
        VdOverrideInfo overrideInfo = new VdOverrideInfo(finalWidth, finalHeight, ((Integer)this.myOpacity.get()).intValue(), ((Boolean)this.myAutoMirrored.get()).booleanValue());
        return VdPreview.overrideXmlContent((Document)vdDocument, (VdOverrideInfo)overrideInfo, (StringBuilder)errorBuffer);
    }

    public static final class ParseResult {
        private static final ParseResult INVALID = new ParseResult();
        @NotNull
        private final String myErrors;
        @NotNull
        private final BufferedImage myImage;
        private final int myOriginalWidth;
        private final int myOriginalHeight;
        private final boolean myIsValid;
        @NotNull
        private final String myXmlContent;

        private ParseResult() {
            this("", AssetStudioUtils.createDummyImage(), 0, 0, "");
        }

        public ParseResult(@NotNull String errors) {
            if (errors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult", "<init>"));
            }
            this(errors, INVALID.getImage(), 0, 0, "");
        }

        public ParseResult(@NotNull String errors, @NotNull BufferedImage image, int originalWidth, int originalHeight, @NotNull String xmlContent) {
            if (errors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult", "<init>"));
            }
            if (image == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult", "<init>"));
            }
            if (xmlContent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlContent", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult", "<init>"));
            }
            this.myErrors = errors;
            this.myImage = image;
            this.myOriginalWidth = originalWidth;
            this.myOriginalHeight = originalHeight;
            this.myXmlContent = xmlContent;
            this.myIsValid = originalWidth > 0 && originalHeight > 0;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        public int getOriginalWidth() {
            return this.myOriginalWidth;
        }

        public int getOriginalHeight() {
            return this.myOriginalHeight;
        }

        @NotNull
        public String getErrors() {
            String string = this.myErrors;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult", "getErrors"));
            }
            return string;
        }

        @NotNull
        public BufferedImage getImage() {
            BufferedImage bufferedImage = this.myImage;
            if (bufferedImage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult", "getImage"));
            }
            return bufferedImage;
        }

        @NotNull
        public String getXmlContent() {
            String string = this.myXmlContent;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult", "getXmlContent"));
            }
            return string;
        }
    }

    public static enum FileType {
        SVG,
        LAYERED_IMAGE,
        VECTOR_DRAWABLE;

    }
}

