/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.deprecated;

import com.android.tools.idea.npw.ChooseTemplateStep;
import com.android.tools.idea.npw.NewModuleWizardState;
import com.android.tools.idea.npw.WizardPath;
import com.android.tools.idea.npw.deprecated.ImportSourceModulePath;
import com.android.tools.idea.npw.deprecated.WrapArchiveOptionsStep;
import com.android.tools.idea.npw.importing.CreateModuleFromArchiveAction;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class WrapArchiveWizardPath
implements WizardPath {
    protected static final String KEY_ARCHIVE = "newmodule.wrap.archivePath";
    protected static final String KEY_GRADLE_PATH = "newmodule.wrap.gradlePath";
    protected static final String KEY_MODULES_FOR_DEPENDENCY_UPDATE = "newmodule.wrap.updateDeps";
    protected static final String KEY_MOVE_ARCHIVE = "newmodule.wrap.move";
    private final Project myProject;
    private Collection<ModuleWizardStep> steps;
    private NewModuleWizardState myWizardState;

    public WrapArchiveWizardPath(@NotNull NewModuleWizardState wizardState, @Nullable Project project, @Nullable TemplateWizardStep.UpdateListener listener, @Nullable Icon sidePanelIcon) {
        if (wizardState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardState", "com/android/tools/idea/npw/deprecated/WrapArchiveWizardPath", "<init>"));
        }
        this.myWizardState = wizardState;
        this.myProject = project;
        this.steps = Collections.singleton(new WrapArchiveOptionsStep(project, wizardState, sidePanelIcon));
        if (listener != null) {
            for (ModuleWizardStep step : this.steps) {
                step.registerStepListener(listener::update);
            }
        }
    }

    @Override
    public Collection<ModuleWizardStep> getSteps() {
        return this.steps;
    }

    @Override
    public void update() {
        for (ModuleWizardStep step : this.steps) {
            step.updateStep();
        }
    }

    @Override
    public void createModule() {
        if (this.myProject != null) {
            String archivePath = this.myWizardState.getString(KEY_ARCHIVE);
            String path = this.myWizardState.getString(KEY_GRADLE_PATH);
            boolean move = this.myWizardState.getBoolean(KEY_MOVE_ARCHIVE);
            Module[] modules = (Module[])this.myWizardState.get(KEY_MODULES_FOR_DEPENDENCY_UPDATE);
            Module containingModule = null;
            if (modules != null && modules.length > 0) {
                containingModule = modules[0];
            }
            String gradlePath = WrapArchiveWizardPath.makeAbsolute(path);
            CreateModuleFromArchiveAction action = new CreateModuleFromArchiveAction(this.myProject, gradlePath, archivePath, move, containingModule);
            action.execute();
        }
    }

    @VisibleForTesting
    @Nullable
    @Contract(value="null -> null;!null -> !null")
    static String makeAbsolute(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return ":";
        }
        if (!string.startsWith(":")) {
            return ":" + string.trim();
        }
        return string.trim();
    }

    @Override
    public boolean isStepVisible(ModuleWizardStep step) {
        return this.steps.contains(step);
    }

    @Override
    public Collection<String> getExcludedTemplates() {
        return Collections.singleton("Import Existing Project");
    }

    @Override
    public Collection<ChooseTemplateStep.MetadataListItem> getBuiltInTemplates() {
        ChooseTemplateStep.MetadataListItem template = ImportSourceModulePath.createImportTemplateWithCustomName("Import .JAR or .AAR Package", "Imports an existing JAR or AAR package as a new project module");
        return Collections.singleton(template);
    }

    @Override
    public boolean supportsGlobalWizard() {
        return false;
    }
}

