/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class SourceToGradleModuleModel
extends WizardModel {
    private final Project myProject;
    private final WizardContext myWizardContext;
    private final Map<String, VirtualFile> myModulesToImport;
    private final StringProperty mySourceLocation;

    public SourceToGradleModuleModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/importing/SourceToGradleModuleModel", "<init>"));
        }
        this.myModulesToImport = Maps.newHashMap();
        this.mySourceLocation = new StringValueProperty();
        this.myProject = project;
        this.myWizardContext = new WizardContext(project, (Disposable)this);
        this.mySourceLocation.addConstraint(String::trim);
    }

    @Override
    protected void handleFinished() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModuleImporter.getImporter(this.myWizardContext).importProjects(this.myModulesToImport);
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, null);
        });
    }

    @NotNull
    public StringProperty sourceLocation() {
        StringProperty stringProperty = this.mySourceLocation;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleModel", "sourceLocation"));
        }
        return stringProperty;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleModel", "getProject"));
        }
        return project;
    }

    @NotNull
    public WizardContext getContext() {
        WizardContext wizardContext = this.myWizardContext;
        if (wizardContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleModel", "getContext"));
        }
        return wizardContext;
    }

    public void setModulesToImport(@NotNull Map<String, VirtualFile> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/npw/importing/SourceToGradleModuleModel", "setModulesToImport"));
        }
        this.myModulesToImport.clear();
        this.myModulesToImport.putAll(value);
    }
}

