/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSourceSet {
    @NotNull
    private final String myName;
    @NotNull
    private final AndroidProjectPaths myPaths;

    @NotNull
    public static List<AndroidSourceSet> getSourceSets(@NotNull AndroidFacet androidFacet, @Nullable VirtualFile targetDirectory) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/npw/project/AndroidSourceSet", "getSourceSets"));
        }
        List<AndroidSourceSet> list = AndroidProjectPaths.getSourceProviders(androidFacet, targetDirectory).stream().map(provider -> {
            if (androidFacet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/npw/project/AndroidSourceSet", "lambda$getSourceSets$0"));
            }
            return new AndroidSourceSet(androidFacet, (SourceProvider)provider);
        }).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidSourceSet", "getSourceSets"));
        }
        return list;
    }

    public AndroidSourceSet(@NotNull String name, @NotNull AndroidProjectPaths paths) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/npw/project/AndroidSourceSet", "<init>"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/npw/project/AndroidSourceSet", "<init>"));
        }
        this.myName = name;
        this.myPaths = paths;
    }

    public AndroidSourceSet(@NotNull AndroidFacet facet, @NotNull SourceProvider sourceProvider) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/npw/project/AndroidSourceSet", "<init>"));
        }
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/npw/project/AndroidSourceSet", "<init>"));
        }
        this(sourceProvider.getName(), new AndroidProjectPaths(facet, sourceProvider));
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidSourceSet", "getName"));
        }
        return string;
    }

    @NotNull
    public AndroidProjectPaths getPaths() {
        AndroidProjectPaths androidProjectPaths = this.myPaths;
        if (androidProjectPaths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidSourceSet", "getPaths"));
        }
        return androidProjectPaths;
    }

    @NotNull
    public SourceProvider toSourceProvider() {
        SourceProvider sourceProvider = new SourceProvider(){

            public String getName() {
                return AndroidSourceSet.this.myName;
            }

            public File getManifestFile() {
                return new File(AndroidSourceSet.this.myPaths.getManifestDirectory(), "AndroidManifest.xml");
            }

            public Collection<File> getJavaDirectories() {
                return Collections.singleton(AndroidSourceSet.this.myPaths.getSrcDirectory());
            }

            public Collection<File> getResourcesDirectories() {
                return Collections.emptyList();
            }

            public Collection<File> getAidlDirectories() {
                return Collections.singleton(AndroidSourceSet.this.myPaths.getAidlDirectory());
            }

            public Collection<File> getRenderscriptDirectories() {
                return Collections.emptyList();
            }

            public Collection<File> getCDirectories() {
                return Collections.emptyList();
            }

            public Collection<File> getCppDirectories() {
                return Collections.emptyList();
            }

            public Collection<File> getResDirectories() {
                return Collections.singleton(AndroidSourceSet.this.myPaths.getResDirectory());
            }

            public Collection<File> getAssetsDirectories() {
                return Collections.emptyList();
            }

            public Collection<File> getJniLibsDirectories() {
                return Collections.emptyList();
            }

            public Collection<File> getShadersDirectories() {
                return Collections.emptyList();
            }
        };
        if (sourceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidSourceSet", "toSourceProvider"));
        }
        return sourceProvider;
    }
}

