/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.builder.model.SourceProvider;
import com.android.sdklib.AndroidVersion;
import com.android.tools.adtui.LabelWithEditLink;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.template.GenerateIconsStep;
import com.android.tools.idea.npw.template.IconLoader;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.components.ActivityComboProvider;
import com.android.tools.idea.npw.template.components.CheckboxProvider;
import com.android.tools.idea.npw.template.components.ComponentProvider;
import com.android.tools.idea.npw.template.components.EnumComboProvider;
import com.android.tools.idea.npw.template.components.LabelWithEditLinkProvider;
import com.android.tools.idea.npw.template.components.PackageComboProvider;
import com.android.tools.idea.npw.template.components.ParameterComponentProvider;
import com.android.tools.idea.npw.template.components.SeparatorProvider;
import com.android.tools.idea.npw.template.components.SourceSetComboProvider;
import com.android.tools.idea.npw.template.components.TextFieldProvider;
import com.android.tools.idea.templates.CircularParameterDependencyException;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.ParameterValueResolver;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.TooltipLabel;
import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.adapters.OptionalToValuePropertyAdapter;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.ui.properties.expressions.Expression;
import com.android.tools.idea.ui.properties.swing.IconProperty;
import com.android.tools.idea.ui.properties.swing.SelectedItemProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.properties.swing.VisibleProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigureTemplateParametersStep
extends ModelWizardStep<RenderTemplateModel> {
    private static final String PROJECT_LOCATION_ID = "projectLocation";
    private final List<AndroidSourceSet> mySourceSets;
    private final StringProperty myPackageName;
    private final BindingsManager myBindings;
    private final LoadingCache<File, Optional<Icon>> myThumbnailsCache;
    private final Map<Parameter, RowEntry> myParameterRows;
    private final Map<Parameter, Object> myUserValues;
    private final StringEvaluator myEvaluator;
    private final StringProperty myThumbPath;
    private final StudioWizardStepPanel myStudioPanel;
    @Nullable
    private final AndroidFacet myFacet;
    private final StringProperty myInvalidParameterMessage;
    private final ValidatorPanel myValidatorPanel;
    private JPanel myRootPanel;
    private JLabel myTemplateThumbLabel;
    private JPanel myParametersPanel;
    private JSeparator myFooterSeparator;
    private TooltipLabel myParameterDescriptionLabel;
    private JBScrollPane myParametersScrollPane;
    private JLabel myTemplateDescriptionLabel;
    private EvaluationState myEvaluationState;

    public ConfigureTemplateParametersStep(@NotNull RenderTemplateModel model, @NotNull String title, @NotNull List<AndroidSourceSet> sourceSets, @Nullable AndroidFacet facet) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "<init>"));
        }
        if (sourceSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSets", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "<init>"));
        }
        super(model, title);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myThumbnailsCache = IconLoader.createLoadingCache();
        this.myParameterRows = Maps.newHashMap();
        this.myUserValues = Maps.newHashMap();
        this.myEvaluator = new StringEvaluator();
        this.myThumbPath = new StringValueProperty();
        this.myInvalidParameterMessage = new StringValueProperty();
        this.myEvaluationState = EvaluationState.NOT_EVALUATING;
        this.myFacet = facet;
        this.mySourceSets = sourceSets;
        this.myPackageName = model.packageName();
        this.myValidatorPanel = new ValidatorPanel(this, this.myRootPanel);
        this.myStudioPanel = new StudioWizardStepPanel(this.myValidatorPanel);
        this.myParameterDescriptionLabel.setScope(this.myParametersPanel);
        this.myParametersScrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myTemplateDescriptionLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)this.myTemplateDescriptionLabel.getFont().getSize(), (int)0));
    }

    private static Logger getLog() {
        return Logger.getInstance(ConfigureTemplateParametersStep.class);
    }

    @NotNull
    private static String getRecentsKeyForParameter(@NotNull Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "getRecentsKeyForParameter"));
        }
        String string = "android.template." + parameter.id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "getRecentsKeyForParameter"));
        }
        return string;
    }

    @Nullable
    private static String getRelativePath(@NotNull File base, @NotNull File file) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "getRelativePath"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "getRelativePath"));
        }
        return FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)base.getPath()), (String)FileUtil.toSystemIndependentName((String)file.getPath()), (char)'/');
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        if (((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getIconType() == AndroidIconType.NOTIFICATION) {
            List<GenerateIconsStep> list = Collections.singletonList(new GenerateIconsStep((RenderTemplateModel)this.getModel()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "createDependentSteps"));
            }
            return list;
        }
        Collection<ModelWizardStep> collection = super.createDependentSteps();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "createDependentSteps"));
        }
        return collection;
    }

    @Override
    protected void onEntering() {
        this.resetPanel();
        final TemplateHandle templateHandle = ((RenderTemplateModel)this.getModel()).getTemplateHandle();
        ApplicationManager.getApplication().invokeLater(() -> this.myTemplateDescriptionLabel.setText(WizardUtils.toHtmlString(Strings.nullToEmpty((String)templateHandle.getMetadata().getDescription()))), ModalityState.any());
        final IconProperty thumb = new IconProperty(this.myTemplateThumbLabel);
        VisibleProperty thumbVisibility = new VisibleProperty(this.myTemplateThumbLabel);
        this.myBindings.bind(thumb, new Expression<Optional<Icon>>(new ObservableValue[]{this.myThumbPath}){

            @Override
            @NotNull
            public Optional<Icon> get() {
                Optional optional = (Optional)ConfigureTemplateParametersStep.this.myThumbnailsCache.getUnchecked((Object)new File(templateHandle.getRootPath(), (String)ConfigureTemplateParametersStep.this.myThumbPath.get()));
                if (optional == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$1", "get"));
                }
                return optional;
            }
        });
        this.myBindings.bind(thumbVisibility, new Expression<Boolean>(new ObservableValue[]{thumb}){

            @Override
            @NotNull
            public Boolean get() {
                Boolean bl = ((Optional)thumb.get()).isPresent();
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$2", "get"));
                }
                return bl;
            }
        });
        this.myThumbPath.set(this.getDefaultThumbnailPath());
        final TextProperty parameterDescription = new TextProperty((JLabel)((Object)this.myParameterDescriptionLabel));
        this.myBindings.bind(new VisibleProperty(this.myFooterSeparator), new Expression<Boolean>(new ObservableValue[]{parameterDescription}){

            @Override
            @NotNull
            public Boolean get() {
                Boolean bl = !parameterDescription.get().isEmpty();
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$3", "get"));
                }
                return bl;
            }
        });
        Module module = this.myFacet == null ? null : this.myFacet.getModule();
        Collection<Parameter> parameters = templateHandle.getMetadata().getParameters();
        for (final Parameter parameter : parameters) {
            RowEntry<?> row = this.createRowForParameter(module, parameter);
            ObservableValue<?> property = row.getProperty();
            if (property != null) {
                property.addListener(sender -> {
                    if (this.myEvaluationState != EvaluationState.EVALUATING) {
                        this.myUserValues.put(parameter, property.get());
                        this.enqueueEvaluateParameters();
                    }
                });
                final ActionGroup resetParameterGroup = new ActionGroup(){

                    @NotNull
                    public AnAction[] getChildren(@Nullable AnActionEvent e) {
                        AnAction[] anActionArray = new AnAction[]{new ResetParameterAction(parameter)};
                        if (anActionArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$4", "getChildren"));
                        }
                        return anActionArray;
                    }
                };
                row.getComponent().addMouseListener((MouseListener)new PopupHandler(){

                    public void invokePopup(Component comp, int x, int y) {
                        ActionManager.getInstance().createActionPopupMenu("unknown", resetParameterGroup).getComponent().show(comp, x, y);
                    }
                });
            }
            this.myParameterRows.put(parameter, row);
            row.addToPanel(this.myParametersPanel);
        }
        if (this.mySourceSets.size() > 1) {
            RowEntry<JComboBox> row = new RowEntry<JComboBox>("Target Source Set", new SourceSetComboProvider(this.mySourceSets));
            row.setEnabled(this.mySourceSets.size() > 1);
            row.addToPanel(this.myParametersPanel);
            SelectedItemProperty sourceSet = (SelectedItemProperty)row.getProperty();
            assert (sourceSet != null);
            this.myBindings.bind(((RenderTemplateModel)this.getModel()).getSourceSet(), new OptionalToValuePropertyAdapter(sourceSet));
            sourceSet.addListener(sender -> this.enqueueEvaluateParameters());
        }
        this.myValidatorPanel.registerValidator(this.myInvalidParameterMessage, message -> message.isEmpty() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, (String)message));
        this.evaluateParameters();
    }

    private RowEntry<?> createRowForParameter(@Nullable Module module, @NotNull Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "createRowForParameter"));
        }
        if ("packageName".equals(parameter.id)) {
            assert (parameter.name != null);
            RowEntry<Object> rowEntry = module != null ? new RowEntry<EditorComboBox>(parameter.name, new PackageComboProvider(module.getProject(), parameter, (String)this.myPackageName.get(), ConfigureTemplateParametersStep.getRecentsKeyForParameter(parameter))) : new RowEntry<LabelWithEditLink>(parameter.name, new LabelWithEditLinkProvider(parameter));
            StringProperty packageName = (StringProperty)rowEntry.getProperty();
            assert (packageName != null);
            this.myBindings.bindTwoWay(packageName, this.myPackageName);
            return rowEntry;
        }
        if ("parentActivityClass".equals(parameter.id) && module != null) {
            assert (parameter.name != null);
            return new RowEntry<ReferenceEditorComboWithBrowseButton>(parameter.name, new ActivityComboProvider(module, parameter, ConfigureTemplateParametersStep.getRecentsKeyForParameter(parameter)));
        }
        switch (parameter.type) {
            case STRING: {
                assert (parameter.name != null);
                return new RowEntry<JTextField>(parameter.name, new TextFieldProvider(parameter));
            }
            case BOOLEAN: {
                return new RowEntry<JCheckBox>(new CheckboxProvider(parameter), RowEntry.WantGrow.NO);
            }
            case SEPARATOR: {
                return new RowEntry<JSeparator>(new SeparatorProvider(parameter), RowEntry.WantGrow.YES);
            }
            case ENUM: {
                assert (parameter.name != null);
                return new RowEntry<JComboBox>(parameter.name, new EnumComboProvider(parameter));
            }
        }
        throw new IllegalStateException(String.format("Can't create UI for unknown component type: %1$s (%2$s)", new Object[]{parameter.type, parameter.id}));
    }

    private void enqueueEvaluateParameters() {
        if (this.myEvaluationState == EvaluationState.REQUEST_ENQUEUED) {
            return;
        }
        this.myEvaluationState = EvaluationState.REQUEST_ENQUEUED;
        ApplicationManager.getApplication().invokeLater(this::evaluateParameters, ModalityState.any());
    }

    private boolean isNewModule() {
        return this.myFacet == null;
    }

    private boolean isParameterVisible(Parameter parameter) {
        return !this.isNewModule() || !"packageName".equals(parameter.id) && !"isLauncher".equals(parameter.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateParameters() {
        this.myEvaluationState = EvaluationState.EVALUATING;
        Collection<Parameter> parameters = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getParameters();
        try {
            HashMap additionalValues = Maps.newHashMap();
            additionalValues.put("packageName", this.myPackageName.get());
            ObjectProperty<AndroidSourceSet> sourceSet = ((RenderTemplateModel)this.getModel()).getSourceSet();
            additionalValues.put("sourceProviderName", ((AndroidSourceSet)sourceSet.get()).getName());
            HashMap allValues = Maps.newHashMap((Map)additionalValues);
            Map<Parameter, Object> parameterValues = ParameterValueResolver.resolve(parameters, this.myUserValues, additionalValues, new ParameterDeduplicator());
            for (Parameter parameter : parameters) {
                Object value = parameterValues.get(parameter);
                if (value == null) continue;
                this.myParameterRows.get(parameter).setValue(value);
                allValues.put(parameter.id, value);
            }
            for (Parameter parameter : parameters) {
                String enabledStr = Strings.nullToEmpty((String)parameter.enabled);
                if (!enabledStr.isEmpty()) {
                    boolean enabled = this.myEvaluator.evaluateBooleanExpression(enabledStr, allValues, true);
                    this.myParameterRows.get(parameter).setEnabled(enabled);
                }
                if (!this.isParameterVisible(parameter)) {
                    this.myParameterRows.get(parameter).setVisible(false);
                    continue;
                }
                String visibilityStr = Strings.nullToEmpty((String)parameter.visibility);
                if (visibilityStr.isEmpty()) continue;
                boolean visible = this.myEvaluator.evaluateBooleanExpression(visibilityStr, allValues, true);
                this.myParameterRows.get(parameter).setVisible(visible);
            }
            this.myThumbPath.set(this.getCurrentThumbnailPath());
        }
        catch (CircularParameterDependencyException e) {
            ConfigureTemplateParametersStep.getLog().error("Circular dependency between parameters in template %1$s", (Throwable)e, new String[]{((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getTitle()});
        }
        finally {
            this.myEvaluationState = EvaluationState.NOT_EVALUATING;
        }
        this.myInvalidParameterMessage.set(Strings.nullToEmpty((String)this.validateAllParameters()));
    }

    @NotNull
    private String getDefaultThumbnailPath() {
        String string = Strings.nullToEmpty((String)((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getThumbnailPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "getDefaultThumbnailPath"));
        }
        return string;
    }

    @NotNull
    private String getCurrentThumbnailPath() {
        String string = Strings.nullToEmpty((String)((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getThumbnailPath((Function<String, Object>)((Function)parameterId -> {
            Parameter parameter = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getParameter((String)parameterId);
            ObservableValue<?> property = this.myParameterRows.get(parameter).getProperty();
            return property != null ? property.get() : null;
        })));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "getCurrentThumbnailPath"));
        }
        return string;
    }

    @Nullable
    private String validateAllParameters() {
        String message = null;
        Collection<Parameter> parameters = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getParameters();
        Module module = this.myFacet == null ? null : this.myFacet.getModule();
        Project project = ((RenderTemplateModel)this.getModel()).getProject().getValueOrNull();
        SourceProvider sourceProvider = ((AndroidSourceSet)((RenderTemplateModel)this.getModel()).getSourceSet().get()).toSourceProvider();
        for (Parameter parameter : parameters) {
            ObservableValue<?> property = this.myParameterRows.get(parameter).getProperty();
            if (property == null) continue;
            Set<Object> relatedValues = this.getRelatedValues(parameter);
            message = parameter.validate(project, module, sourceProvider, (String)this.myPackageName.get(), property.get(), relatedValues);
            if (message == null) continue;
            break;
        }
        return message;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioPanel;
        if (studioWizardStepPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "getComponent"));
        }
        return studioWizardStepPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        Component[] children = this.myParametersPanel.getComponents();
        for (int i = 0; i < children.length; ++i) {
            boolean isContainer;
            JComponent child = (JComponent)children[i];
            boolean bl = isContainer = child.getComponentCount() > 0;
            if (isContainer || !child.isFocusable() || !child.isVisible()) continue;
            return child;
        }
        return null;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "canGoForward"));
        }
        return observableBool;
    }

    private void createUIComponents() {
        this.myParametersPanel = new JPanel((LayoutManager)new TabularLayout("Fit,*").setVGap(10));
    }

    private void resetPanel() {
        this.myParametersPanel.removeAll();
        this.myParameterRows.clear();
        this.dispose();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myThumbnailsCache.invalidateAll();
    }

    @Override
    protected void onProceeding() {
        File aidlDir;
        File manifestDir;
        File resDir;
        File testDir;
        AndroidSourceSet sourceSet = (AndroidSourceSet)((RenderTemplateModel)this.getModel()).getSourceSet().get();
        AndroidProjectPaths paths = sourceSet.getPaths();
        File moduleRoot = paths.getModuleRoot();
        if (moduleRoot == null) {
            ConfigureTemplateParametersStep.getLog().error(String.format("%s failure: can't create files because module root is not found. Please report this error.", this.getTitle()));
            return;
        }
        for (RowEntry rowEntry : this.myParameterRows.values()) {
            rowEntry.accept();
        }
        Map<String, Object> templateValues = ((RenderTemplateModel)this.getModel()).getTemplateValues();
        templateValues.clear();
        for (Parameter parameter : this.myParameterRows.keySet()) {
            ObservableValue<?> property = this.myParameterRows.get(parameter).getProperty();
            if (property == null) continue;
            templateValues.put(parameter.id, property.get());
        }
        templateValues.put("packageName", this.myPackageName.get());
        templateValues.put("sourceProviderName", sourceSet.getName());
        templateValues.put("isNewProject", this.isNewModule());
        if (this.isNewModule()) {
            templateValues.put("isLauncher", true);
        }
        try {
            File file = this.myFacet == null ? KeystoreUtils.getOrCreateDefaultDebugKeystore() : KeystoreUtils.getDebugKeystore(this.myFacet);
            templateValues.put("debugKeystoreSha1", KeystoreUtils.sha1(file));
        }
        catch (Exception exception) {
            ConfigureTemplateParametersStep.getLog().info("Could not compute SHA1 hash of debug keystore.", (Throwable)exception);
            templateValues.put("debugKeystoreSha1", "");
        }
        if (this.myFacet == null) {
            AndroidVersionsInfo.VersionItem versionItem = ((RenderTemplateModel)this.getModel()).androidSdkInfo().getValue();
            templateValues.put("minApiLevel", versionItem.getApiLevel());
            templateValues.put("minApi", versionItem.getApiLevelStr());
            templateValues.put("buildApi", versionItem.getBuildApiLevel());
            templateValues.put("buildApiString", versionItem.getBuildApiLevelStr());
            templateValues.put("targetApi", versionItem.getTargetApiLevel());
            templateValues.put("targetApiString", versionItem.getTargetApiLevelStr());
        } else {
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(this.myFacet.getModule());
            if (androidPlatform != null) {
                templateValues.put("buildApi", androidPlatform.getTarget().getVersion().getFeatureLevel());
                templateValues.put("buildApiString", TemplateMetadata.getBuildApiString(androidPlatform.getTarget().getVersion()));
            }
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(this.myFacet);
            AndroidVersion minSdkVersion = moduleInfo.getMinSdkVersion();
            String minSdkName = minSdkVersion.getApiString();
            templateValues.put("minApi", minSdkName);
            templateValues.put("targetApi", moduleInfo.getTargetSdkVersion().getApiLevel());
            templateValues.put("minApiLevel", minSdkVersion.getFeatureLevel());
            templateValues.put("isLibraryProject", this.myFacet.isLibraryProject());
            String applicationPackage = AndroidPackageUtils.getPackageForApplication(this.myFacet);
            if (!((String)this.myPackageName.get()).equals(applicationPackage)) {
                templateValues.put("applicationPackage", AndroidPackageUtils.getPackageForApplication(this.myFacet));
            }
        }
        templateValues.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getAbsolutePath()));
        String string = ((String)this.myPackageName.get()).replace('.', File.separatorChar);
        File srcDir = paths.getSrcDirectory();
        if (srcDir != null) {
            srcDir = new File(srcDir, string);
            templateValues.put("srcDir", ConfigureTemplateParametersStep.getRelativePath(moduleRoot, srcDir));
            templateValues.put("srcOut", FileUtil.toSystemIndependentName((String)srcDir.getAbsolutePath()));
        }
        if ((testDir = paths.getTestDirectory()) != null) {
            testDir = new File(testDir, string);
            templateValues.put("testDir", ConfigureTemplateParametersStep.getRelativePath(moduleRoot, testDir));
            templateValues.put("testOut", FileUtil.toSystemIndependentName((String)testDir.getAbsolutePath()));
        }
        if ((resDir = paths.getResDirectory()) != null) {
            templateValues.put("resDir", ConfigureTemplateParametersStep.getRelativePath(moduleRoot, resDir));
            templateValues.put("resOut", FileUtil.toSystemIndependentName((String)resDir.getPath()));
        }
        if ((manifestDir = paths.getManifestDirectory()) != null) {
            templateValues.put("manifestDir", ConfigureTemplateParametersStep.getRelativePath(moduleRoot, manifestDir));
            templateValues.put("manifestOut", FileUtil.toSystemIndependentName((String)manifestDir.getPath()));
        }
        if ((aidlDir = paths.getAidlDirectory()) != null) {
            templateValues.put("aidlDir", ConfigureTemplateParametersStep.getRelativePath(moduleRoot, aidlDir));
            templateValues.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlDir.getPath()));
        }
        templateValues.put(PROJECT_LOCATION_ID, moduleRoot.getParent());
        String moduleName = moduleRoot.getName();
        templateValues.put("projectName", moduleName);
    }

    private Set<Object> getRelatedValues(@NotNull Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep", "getRelatedValues"));
        }
        HashSet relatedValues = Sets.newHashSet();
        for (Parameter related : parameter.template.getRelatedParams(parameter)) {
            ObservableValue<?> property = this.myParameterRows.get(related).getProperty();
            if (property == null) continue;
            relatedValues.add(property.get());
        }
        return relatedValues;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JBScrollPane jBScrollPane;
        JLabel jLabel2;
        TooltipLabel tooltipLabel;
        JSeparator jSeparator;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myFooterSeparator = jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myParameterDescriptionLabel = tooltipLabel = new TooltipLabel();
        ((JLabel)((Object)tooltipLabel)).setText("");
        jPanel.add((Component)((Object)tooltipLabel), new GridConstraints(3, 1, 1, 1, 8, 0, 1, 2, null, null, null));
        this.myTemplateThumbLabel = jLabel2 = new JLabel();
        jLabel2.setVerticalAlignment(1);
        jLabel2.setHorizontalTextPosition(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myParametersScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 7, null, null, null));
        JPanel jPanel2 = this.myParametersPanel;
        jPanel2.setOpaque(true);
        jBScrollPane.setViewportView(jPanel2);
        this.myTemplateDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private final class ResetParameterAction
    extends AnAction {
        @NotNull
        private final Parameter myParameter;

        public ResetParameterAction(Parameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$ResetParameterAction", "<init>"));
            }
            super("Restore default value", "Discards any user modifications made to this parameter", AllIcons.General.Reset);
            this.myParameter = parameter;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ConfigureTemplateParametersStep.this.myUserValues.containsKey(this.myParameter));
        }

        public void actionPerformed(AnActionEvent e) {
            ConfigureTemplateParametersStep.this.myUserValues.remove(this.myParameter);
            ConfigureTemplateParametersStep.this.evaluateParameters();
        }
    }

    private final class ParameterDeduplicator
    implements ParameterValueResolver.Deduplicator {
        private ParameterDeduplicator() {
        }

        @Override
        @Nullable
        public String deduplicate(@NotNull Parameter parameter, @Nullable String value) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$ParameterDeduplicator", "deduplicate"));
            }
            if (Strings.isNullOrEmpty((String)value) || !parameter.constraints.contains((Object)Parameter.Constraint.UNIQUE)) {
                return value;
            }
            String suggested = value;
            String extPart = Strings.emptyToNull((String)Files.getFileExtension((String)value));
            String namePart = value.replace("." + extPart, "");
            namePart = namePart.replaceAll("\\d*$", "");
            Joiner filenameJoiner = Joiner.on((char)'.').skipNulls();
            int suffix = 2;
            Module module = ConfigureTemplateParametersStep.this.myFacet != null ? ConfigureTemplateParametersStep.this.myFacet.getModule() : null;
            Project project = ((RenderTemplateModel)ConfigureTemplateParametersStep.this.getModel()).getProject().getValueOrNull();
            Set relatedValues = ConfigureTemplateParametersStep.this.getRelatedValues(parameter);
            SourceProvider sourceProvider = ((AndroidSourceSet)((RenderTemplateModel)ConfigureTemplateParametersStep.this.getModel()).getSourceSet().get()).toSourceProvider();
            while (!parameter.uniquenessSatisfied(project, module, sourceProvider, (String)ConfigureTemplateParametersStep.this.myPackageName.get(), suggested, relatedValues)) {
                suggested = filenameJoiner.join((Object)(namePart + suffix), (Object)extPart, new Object[0]);
                ++suffix;
            }
            return suggested;
        }
    }

    private static final class RowEntry<T extends JComponent> {
        @Nullable
        private final JPanel myHeader;
        @NotNull
        private final ComponentProvider<T> myComponentProvider;
        @NotNull
        private final T myComponent;
        @Nullable
        private final AbstractProperty<?> myProperty;
        @NotNull
        private final WantGrow myWantGrow;

        public RowEntry(@NotNull String headerText, @NotNull ComponentProvider<T> componentProvider) {
            if (headerText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerText", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$RowEntry", "<init>"));
            }
            if (componentProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentProvider", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$RowEntry", "<init>"));
            }
            this.myHeader = new JPanel(new FlowLayout(0));
            JBLabel headerLabel = new JBLabel(headerText + ":");
            this.myHeader.add((Component)headerLabel);
            this.myHeader.add(Box.createHorizontalStrut(20));
            this.myWantGrow = WantGrow.NO;
            this.myComponentProvider = componentProvider;
            this.myComponent = componentProvider.createComponent();
            this.myProperty = componentProvider.createProperty(this.myComponent);
            headerLabel.setLabelFor(this.myComponent);
        }

        public RowEntry(@NotNull ParameterComponentProvider<T> componentProvider, @NotNull WantGrow stretch) {
            if (componentProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentProvider", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$RowEntry", "<init>"));
            }
            if (stretch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stretch", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$RowEntry", "<init>"));
            }
            this.myHeader = null;
            this.myWantGrow = stretch;
            this.myComponentProvider = componentProvider;
            this.myComponent = componentProvider.createComponent();
            this.myProperty = componentProvider.createProperty(this.myComponent);
        }

        @Nullable
        public ObservableValue<?> getProperty() {
            return this.myProperty;
        }

        public void addToPanel(@NotNull JPanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$RowEntry", "addToPanel"));
            }
            assert (panel.getLayout().getClass().equals(TabularLayout.class));
            int row = panel.getComponentCount();
            if (this.myHeader != null) {
                panel.add((Component)this.myHeader, new TabularLayout.Constraint(row, 0));
                assert (this.myWantGrow == WantGrow.NO);
            }
            int colspan = this.myWantGrow == WantGrow.YES ? 2 : 1;
            panel.add((Component)this.myComponent, new TabularLayout.Constraint(row, 1, colspan));
        }

        public void setEnabled(boolean enabled) {
            if (this.myHeader != null) {
                this.myHeader.setEnabled(enabled);
            }
            ((JComponent)this.myComponent).setEnabled(enabled);
        }

        public void setVisible(boolean visible) {
            if (this.myHeader != null) {
                this.myHeader.setVisible(visible);
            }
            ((JComponent)this.myComponent).setVisible(visible);
        }

        public <V> void setValue(@NotNull V value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$RowEntry", "setValue"));
            }
            assert (this.myProperty != null);
            this.myProperty.set(value);
        }

        @NotNull
        public JComponent getComponent() {
            T t = this.myComponent;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ConfigureTemplateParametersStep$RowEntry", "getComponent"));
            }
            return t;
        }

        public void accept() {
            this.myComponentProvider.accept(this.myComponent);
        }

        public static enum WantGrow {
            NO,
            YES;

        }
    }

    private static enum EvaluationState {
        NOT_EVALUATING,
        REQUEST_ENQUEUED,
        EVALUATING;

    }
}

