/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsPanel;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Strings;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class GenerateIconsStep
extends ModelWizardStep<RenderTemplateModel> {
    private final StudioWizardStepPanel myStudioPanel;
    private final GenerateIconsPanel myGenerateIconsPanel;
    private final ListenerManager myListeners;

    public GenerateIconsStep(@NotNull RenderTemplateModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/npw/template/GenerateIconsStep", "<init>"));
        }
        super(model, "Generate Icons");
        this.myListeners = new ListenerManager();
        AndroidIconType iconType = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getIconType();
        assert (iconType != null);
        this.myGenerateIconsPanel = new GenerateIconsPanel(this, ((AndroidSourceSet)model.getSourceSet().get()).getPaths(), iconType);
        this.myListeners.receiveAndFire(model.getSourceSet(), value -> this.myGenerateIconsPanel.setProjectPaths(value.getPaths()));
        this.myStudioPanel = new StudioWizardStepPanel(this.myGenerateIconsPanel, "Convert a source asset into " + iconType.getDisplayName().toLowerCase(Locale.getDefault()));
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioPanel;
        if (studioWizardStepPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/GenerateIconsStep", "getComponent"));
        }
        return studioWizardStepPanel;
    }

    @Override
    protected void onEntering() {
        TemplateHandle templateHandle = ((RenderTemplateModel)this.getModel()).getTemplateHandle();
        String iconNameExpression = templateHandle.getMetadata().getIconName();
        String iconName = null;
        if (iconNameExpression != null && !iconNameExpression.isEmpty()) {
            StringEvaluator evaluator = new StringEvaluator();
            iconName = evaluator.evaluate(iconNameExpression, ((RenderTemplateModel)this.getModel()).getTemplateValues());
        }
        this.myGenerateIconsPanel.setOutputName(Strings.nullToEmpty(iconName));
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myGenerateIconsPanel.hasErrors().not();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/GenerateIconsStep", "canGoForward"));
        }
        return observableBool;
    }

    @Override
    protected void onProceeding() {
        ((RenderTemplateModel)this.getModel()).setIconGenerator(this.myGenerateIconsPanel.getIconGenerator());
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }
}

