/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderTemplateModel
extends WizardModel {
    @NotNull
    private final String myCommandName;
    @NotNull
    private final OptionalProperty<Project> myProject;
    @NotNull
    private final ObjectProperty<AndroidSourceSet> mySourceSet;
    @NotNull
    private final OptionalProperty<AndroidVersionsInfo.VersionItem> myAndroidSdkInfo;
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final Map<String, Object> myTemplateValues;
    @NotNull
    private TemplateHandle myTemplateHandle;
    @Nullable
    private AndroidIconGenerator myIconGenerator;

    public RenderTemplateModel(@NotNull Project project, @NotNull TemplateHandle templateHandle, @NotNull String initialPackageSuggestion, @NotNull AndroidSourceSet sourceSet, @NotNull String commandName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (templateHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateHandle", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (initialPackageSuggestion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialPackageSuggestion", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (sourceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSet", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        this.myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
        this.myTemplateValues = Maps.newHashMap();
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myPackageName = new StringValueProperty(initialPackageSuggestion);
        this.mySourceSet = new ObjectValueProperty<AndroidSourceSet>(sourceSet);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
    }

    public RenderTemplateModel(@NotNull OptionalProperty<Project> project, @NotNull StringProperty packageName, @NotNull TemplateHandle templateHandle, @NotNull AndroidSourceSet sourceSet, @NotNull String commandName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (templateHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateHandle", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (sourceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSet", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        this.myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
        this.myTemplateValues = Maps.newHashMap();
        this.myProject = project;
        this.myPackageName = packageName;
        this.mySourceSet = new ObjectValueProperty<AndroidSourceSet>(sourceSet);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
    }

    private static Logger getLog() {
        return Logger.getInstance(RenderTemplateModel.class);
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        Map<String, Object> map = this.myTemplateValues;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/RenderTemplateModel", "getTemplateValues"));
        }
        return map;
    }

    @NotNull
    public ObjectProperty<AndroidSourceSet> getSourceSet() {
        ObjectProperty<AndroidSourceSet> objectProperty = this.mySourceSet;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/RenderTemplateModel", "getSourceSet"));
        }
        return objectProperty;
    }

    @NotNull
    public StringProperty packageName() {
        StringProperty stringProperty = this.myPackageName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/RenderTemplateModel", "packageName"));
        }
        return stringProperty;
    }

    public void setTemplateHandle(@NotNull TemplateHandle templateHandle) {
        if (templateHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateHandle", "com/android/tools/idea/npw/template/RenderTemplateModel", "setTemplateHandle"));
        }
        this.myTemplateHandle = templateHandle;
    }

    @NotNull
    public TemplateHandle getTemplateHandle() {
        TemplateHandle templateHandle = this.myTemplateHandle;
        if (templateHandle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/RenderTemplateModel", "getTemplateHandle"));
        }
        return templateHandle;
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        OptionalProperty<Project> optionalProperty = this.myProject;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/RenderTemplateModel", "getProject"));
        }
        return optionalProperty;
    }

    public OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo() {
        return this.myAndroidSdkInfo;
    }

    public void setIconGenerator(@NotNull AndroidIconGenerator iconGenerator) {
        if (iconGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconGenerator", "com/android/tools/idea/npw/template/RenderTemplateModel", "setIconGenerator"));
        }
        this.myIconGenerator = iconGenerator;
    }

    @Override
    protected void handleFinished() {
        ArrayList filesToReformat;
        if (!((Optional)this.myProject.get()).isPresent()) {
            RenderTemplateModel.getLog().error("RenderTemplateModel did not collect expected information and will not complete. Please report this error.");
            return;
        }
        final AndroidProjectPaths paths = ((AndroidSourceSet)this.mySourceSet.get()).getPaths();
        final Project project = this.myProject.getValue();
        boolean canRender = this.renderTemplate(true, project, paths, null, null);
        if (!canRender) {
            return;
        }
        final ArrayList filesToOpen = Lists.newArrayListWithExpectedSize((int)3);
        boolean success = (Boolean)new WriteCommandAction<Boolean>(project, this.myCommandName, new PsiFile[0], (List)(filesToReformat = Lists.newArrayList())){
            final /* synthetic */ List val$filesToReformat;
            {
                this.val$filesToReformat = list2;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result<Boolean> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/template/RenderTemplateModel$1", "run"));
                }
                boolean success = RenderTemplateModel.this.renderTemplate(false, project, paths, filesToOpen, this.val$filesToReformat);
                if (success && RenderTemplateModel.this.myIconGenerator != null) {
                    RenderTemplateModel.this.myIconGenerator.generateImageIconsIntoPath(paths);
                }
                result.setResult((Object)success);
            }
        }.execute().getResultObject();
        if (success) {
            ApplicationManager.getApplication().invokeLater(() -> TemplateUtils.openEditors(project, filesToOpen, true));
        }
    }

    private boolean renderTemplate(boolean dryRun, @NotNull Project project, @NotNull AndroidProjectPaths paths, @Nullable List<File> filesToOpen, @Nullable List<File> filesToReformat) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/template/RenderTemplateModel", "renderTemplate"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/npw/template/RenderTemplateModel", "renderTemplate"));
        }
        Template template = this.myTemplateHandle.getTemplate();
        File moduleRoot = paths.getModuleRoot();
        if (moduleRoot == null) {
            return false;
        }
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(this.myCommandName).withDryRun(dryRun).withShowErrors(true).withModuleRoot(paths.getModuleRoot()).withParams(this.myTemplateValues).intoOpenFiles(filesToOpen).intoTargetFiles(filesToReformat).build();
        return template.render(context);
    }
}

