/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.util.LaunchUtils;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.InstantAppUrlFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurations {
    @NotNull
    public static AndroidRunConfigurations getInstance() {
        AndroidRunConfigurations androidRunConfigurations = (AndroidRunConfigurations)ServiceManager.getService(AndroidRunConfigurations.class);
        if (androidRunConfigurations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/project/AndroidRunConfigurations", "getInstance"));
        }
        return androidRunConfigurations;
    }

    public void createRunConfiguration(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/project/AndroidRunConfigurations", "createRunConfiguration"));
        }
        Module module = facet.getModule();
        ConfigurationFactory configurationFactory = AndroidRunConfigurationType.getInstance().getFactory();
        List configurations = RunManager.getInstance((Project)module.getProject()).getConfigurationsList(configurationFactory.getType());
        for (RunConfiguration configuration : configurations) {
            if (!(configuration instanceof AndroidRunConfiguration) || ((JavaRunConfigurationModule)((AndroidRunConfiguration)configuration).getConfigurationModule()).getModule() != module) continue;
            return;
        }
        this.addRunConfiguration(facet, null, TargetSelectionMode.SHOW_DIALOG, null);
    }

    public void addRunConfiguration(@NotNull AndroidFacet facet, @Nullable String activityClass, @Nullable TargetSelectionMode targetSelectionMode, @Nullable String preferredAvdName) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/project/AndroidRunConfigurations", "addRunConfiguration"));
        }
        Module module = facet.getModule();
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        AndroidRunConfigurationType runConfigurationType = AndroidRunConfigurationType.getInstance();
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(module.getName(), runConfigurationType.getFactory());
        AndroidRunConfiguration configuration = (AndroidRunConfiguration)settings.getConfiguration();
        configuration.setModule(module);
        if (activityClass != null) {
            configuration.setLaunchActivity(activityClass);
        } else if (facet.getProjectType() == 4) {
            configuration.setLaunchUrl(AndroidRunConfigurations.getDefaultRunConfigurationUrl(facet));
        } else {
            configuration.MODE = LaunchUtils.isWatchFaceApp(facet) ? "do_nothing" : "default_activity";
        }
        if (targetSelectionMode != null) {
            configuration.getDeployTargetContext().setTargetSelectionMode(targetSelectionMode);
        }
        if (preferredAvdName != null) {
            configuration.PREFERRED_AVD = preferredAvdName;
        }
        runManager.addConfiguration(settings, false);
        runManager.setSelectedConfiguration(settings);
    }

    @NotNull
    private static String getDefaultRunConfigurationUrl(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/project/AndroidRunConfigurations", "getDefaultRunConfigurationUrl"));
        }
        String defaultUrl = "<<ERROR - NO URL SET>>";
        assert (facet.getProjectType() == 4);
        String foundUrl = new InstantAppUrlFinder(MergedManifest.get(facet)).getDefaultUrl();
        String string = StringUtil.isEmpty((String)foundUrl) ? defaultUrl : foundUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/project/AndroidRunConfigurations", "getDefaultRunConfigurationUrl"));
        }
        return string;
    }
}

