/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.util.PropertiesMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderResult {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final List<ViewInfo> myRootViews;
    @NotNull
    private final List<ViewInfo> mySystemRootViews;
    @NotNull
    private final ImagePool.Image myImage;
    @Nullable
    private final RenderTask myRenderTask;
    @NotNull
    private final Result myRenderResult;
    @NotNull
    private final Map<Object, PropertiesMap> myDefaultProperties;
    @NotNull
    private final Module myModule;

    protected RenderResult(@NotNull PsiFile file, @NotNull Module module, @NotNull RenderLogger logger, @Nullable RenderTask renderTask, @NotNull Result renderResult, @NotNull List<ViewInfo> rootViews, @NotNull List<ViewInfo> systemRootViews, @NotNull ImagePool.Image image, @NotNull Map<Object, PropertiesMap> defaultProperties) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        if (renderResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderResult", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        if (rootViews == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootViews", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        if (systemRootViews == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemRootViews", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        if (defaultProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultProperties", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        this.myRenderTask = renderTask;
        this.myModule = module;
        this.myFile = file;
        this.myLogger = logger;
        this.myRenderResult = renderResult;
        this.myRootViews = rootViews;
        this.mySystemRootViews = systemRootViews;
        this.myImage = image;
        this.myDefaultProperties = defaultProperties;
    }

    @NotNull
    public static RenderResult create(@NotNull RenderTask renderTask, @NotNull RenderSession session, @NotNull PsiFile file, @NotNull RenderLogger logger, @NotNull ImagePool.Image image) {
        if (renderTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderTask", "com/android/tools/idea/rendering/RenderResult", "create"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/android/tools/idea/rendering/RenderResult", "create"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/RenderResult", "create"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderResult", "create"));
        }
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/rendering/RenderResult", "create"));
        }
        List<ViewInfo> rootViews = session.getRootViews();
        List<ViewInfo> systemRootViews = session.getSystemRootViews();
        Map<Object, PropertiesMap> defaultProperties = session.getDefaultProperties();
        RenderResult renderResult = new RenderResult(file, renderTask.getModule(), logger, renderTask, session.getResult(), rootViews != null ? rootViews : Collections.emptyList(), systemRootViews != null ? systemRootViews : Collections.emptyList(), image, defaultProperties != null ? defaultProperties : Collections.emptyMap());
        if (renderResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "create"));
        }
        return renderResult;
    }

    @NotNull
    public static RenderResult createSessionInitializationError(@NotNull RenderTask renderTask, @NotNull PsiFile file, @NotNull RenderLogger logger) {
        if (renderTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderTask", "com/android/tools/idea/rendering/RenderResult", "createSessionInitializationError"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/RenderResult", "createSessionInitializationError"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderResult", "createSessionInitializationError"));
        }
        RenderResult renderResult = new RenderResult(file, renderTask.getModule(), logger, renderTask, Result.Status.ERROR_UNKNOWN.createResult("Failed to initialize session"), Collections.emptyList(), Collections.emptyList(), ImagePool.NULL_POOLED_IMAGE, Collections.emptyMap());
        if (renderResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "createSessionInitializationError"));
        }
        return renderResult;
    }

    @NotNull
    public static RenderResult createBlank(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/RenderResult", "createBlank"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        RenderResult renderResult = new RenderResult(file, module, new RenderLogger(null, module), null, Result.Status.ERROR_UNKNOWN.createResult(""), Collections.emptyList(), Collections.emptyList(), ImagePool.NULL_POOLED_IMAGE, Collections.emptyMap());
        if (renderResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "createBlank"));
        }
        return renderResult;
    }

    @NotNull
    public Result getRenderResult() {
        Result result = this.myRenderResult;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getRenderResult"));
        }
        return result;
    }

    @NotNull
    public RenderLogger getLogger() {
        RenderLogger renderLogger = this.myLogger;
        if (renderLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getLogger"));
        }
        return renderLogger;
    }

    @NotNull
    public ImagePool.Image getRenderedImage() {
        ImagePool.Image image = this.myImage != null ? this.myImage : ImagePool.NULL_POOLED_IMAGE;
        if (image == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getRenderedImage"));
        }
        return image;
    }

    public boolean hasImage() {
        return this.myImage != null && this.myImage != ImagePool.NULL_POOLED_IMAGE;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getFile"));
        }
        return psiFile;
    }

    @Nullable
    public RenderTask getRenderTask() {
        return this.myRenderTask;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getModule"));
        }
        return module;
    }

    @NotNull
    public List<ViewInfo> getRootViews() {
        List<ViewInfo> list = this.myRootViews;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getRootViews"));
        }
        return list;
    }

    @NotNull
    public List<ViewInfo> getSystemRootViews() {
        List<ViewInfo> list = this.mySystemRootViews;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getSystemRootViews"));
        }
        return list;
    }

    @NotNull
    public Map<Object, PropertiesMap> getDefaultProperties() {
        Map<Object, PropertiesMap> map = this.myDefaultProperties;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getDefaultProperties"));
        }
        return map;
    }
}

