/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.errors.ui;

import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.HtmlBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderErrorModel
extends AbstractListModel<Issue> {
    private ImmutableList<Issue> myIssues;

    public RenderErrorModel(@NotNull Collection<Issue> issues) {
        if (issues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issues", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel", "<init>"));
        }
        this.myIssues = ImmutableList.of();
        this.myIssues = ImmutableList.copyOf(issues);
    }

    @NotNull
    public ImmutableList<Issue> getIssues() {
        ImmutableList<Issue> immutableList = this.myIssues;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel", "getIssues"));
        }
        return immutableList;
    }

    @Override
    public int getSize() {
        return this.myIssues.size();
    }

    @Override
    public Issue getElementAt(int index) {
        return (Issue)this.myIssues.get(index);
    }

    public void setIssues(@NotNull Collection<Issue> issues) {
        if (issues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issues", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel", "setIssues"));
        }
        this.myIssues = ImmutableList.copyOf(issues);
        this.fireContentsChanged(this, 0, this.myIssues.size());
    }

    @NotNull
    public HighlightSeverity getHighestSeverity() {
        HighlightSeverity highlightSeverity = this.myIssues.stream().map(Issue::getSeverity).sorted(Collections.reverseOrder()).findFirst().orElse(HighlightSeverity.INFORMATION);
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel", "getHighestSeverity"));
        }
        return highlightSeverity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderErrorModel that = (RenderErrorModel)o;
        return Objects.equals(this.myIssues, that.myIssues);
    }

    public int hashCode() {
        return Objects.hash(this.myIssues);
    }

    public static class Issue
    implements Comparable<Issue> {
        private HighlightSeverity mySeverity = HighlightSeverity.INFORMATION;
        private String mySummary;
        private String myHtmlContent;
        private HyperlinkListener myHyperlinkListener;
        private String myCachedPlainContent;

        private Issue() {
        }

        @NotNull
        public static Builder builder() {
            Builder builder = new Builder();
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue", "builder"));
            }
            return builder;
        }

        @NotNull
        public HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.mySeverity;
            if (highlightSeverity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue", "getSeverity"));
            }
            return highlightSeverity;
        }

        @NotNull
        public String getSummary() {
            String string = StringUtil.notNullize((String)this.mySummary);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue", "getSummary"));
            }
            return string;
        }

        @NotNull
        public String getHtmlContent() {
            String string = StringUtil.notNullize((String)this.myHtmlContent);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue", "getHtmlContent"));
            }
            return string;
        }

        @NotNull
        private String getPlainContent() {
            if (this.myCachedPlainContent == null) {
                this.myCachedPlainContent = TextFormat.HTML.toText(this.myHtmlContent);
            }
            String string = this.myCachedPlainContent;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue", "getPlainContent"));
            }
            return string;
        }

        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myHyperlinkListener;
        }

        @Override
        public int compareTo(@NotNull Issue o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue", "compareTo"));
            }
            return ComparisonChain.start().compare((Comparable)o.getSeverity(), (Comparable)this.getSeverity()).compare((Comparable)((Object)this.mySummary), (Comparable)((Object)o.mySummary)).result();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Issue issue = (Issue)o;
            return Objects.equals(this.mySeverity, issue.mySeverity) && Objects.equals(this.mySummary, issue.mySummary) && Objects.equals(this.getPlainContent(), issue.getPlainContent());
        }

        public int hashCode() {
            return Objects.hash(this.mySeverity, this.mySummary, this.myHtmlContent);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("severity", (Object)this.mySeverity).add("summary", (Object)this.mySummary).add("htmlContent", (Object)this.myHtmlContent).add("hasHyperlinkListener", this.myHyperlinkListener != null).toString();
        }

        public static class Builder {
            private final Issue myIssue = new Issue();

            @NotNull
            private Builder setHtmlContent(@NotNull String htmlContent) {
                if (htmlContent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlContent", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setHtmlContent"));
                }
                this.myIssue.myHtmlContent = htmlContent;
                this.myIssue.myCachedPlainContent = null;
                Builder builder = this;
                if (builder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setHtmlContent"));
                }
                return builder;
            }

            @NotNull
            public Builder setHtmlContent(@NotNull HtmlBuilder htmlBuilder) {
                if (htmlBuilder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlBuilder", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setHtmlContent"));
                }
                Builder builder = this.setHtmlContent(htmlBuilder.getStringBuilder().toString());
                if (builder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setHtmlContent"));
                }
                return builder;
            }

            @NotNull
            public Builder setSeverity(@NotNull HighlightSeverity severity) {
                if (severity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setSeverity"));
                }
                this.myIssue.mySeverity = severity;
                Builder builder = this;
                if (builder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setSeverity"));
                }
                return builder;
            }

            @NotNull
            public Builder setSeverity(@NotNull HighlightSeverity severity, int priority) {
                if (severity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setSeverity"));
                }
                this.myIssue.mySeverity = new HighlightSeverity(severity.myName, severity.myVal + priority);
                Builder builder = this;
                if (builder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setSeverity"));
                }
                return builder;
            }

            @NotNull
            public Builder setSummary(@NotNull String summary) {
                if (summary == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "summary", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setSummary"));
                }
                this.myIssue.mySummary = summary;
                Builder builder = this;
                if (builder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setSummary"));
                }
                return builder;
            }

            @NotNull
            public Builder setLinkHandler(@NotNull HyperlinkListener listener) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setLinkHandler"));
                }
                this.myIssue.myHyperlinkListener = listener;
                Builder builder = this;
                if (builder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "setLinkHandler"));
                }
                return builder;
            }

            @NotNull
            public Issue build() {
                if (this.myIssue.mySummary == null) {
                    this.myIssue.mySummary = "";
                }
                if (this.myIssue.mySeverity == null) {
                    this.myIssue.mySeverity = HighlightSeverity.INFORMATION;
                }
                if (this.myIssue.myHtmlContent == null) {
                    this.myIssue.myHtmlContent = "";
                }
                Issue issue = this.myIssue;
                if (issue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder", "build"));
                }
                return issue;
            }
        }
    }
}

