/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.DataBindingResourceType;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LayoutDataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergedDataBindingInfo
implements DataBindingInfo {
    final List<LayoutDataBindingInfo> myInfoList;
    private LayoutDataBindingInfo myBaseInfo;
    private PsiClass myPsiClass;
    private final CachedValue<List<DataBindingInfo.ViewWithId>> myViewWithIdsCache;
    private final CachedValue<List<PsiDataBindingResourceItem>>[] myResourceItemCache;

    public MergedDataBindingInfo(List<LayoutDataBindingInfo> infoList) {
        this.myInfoList = infoList;
        this.myBaseInfo = this.selectBaseInfo();
        CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)this.myBaseInfo.getProject());
        this.myViewWithIdsCache = cacheManager.createCachedValue(() -> {
            HashSet used = new HashSet();
            ArrayList result = new ArrayList();
            for (DataBindingInfo dataBindingInfo : this.myInfoList) {
                dataBindingInfo.getViewsWithIds().forEach(arg_0 -> MergedDataBindingInfo.lambda$null$0((Set)used, result, arg_0));
            }
            return CachedValueProvider.Result.create(result, this.myInfoList);
        }, false);
        this.myResourceItemCache = new CachedValue[DataBindingResourceType.values().length];
        for (DataBindingResourceType type : DataBindingResourceType.values()) {
            this.myResourceItemCache[type.ordinal()] = cacheManager.createCachedValue(() -> {
                HashSet used = new HashSet();
                ArrayList<PsiDataBindingResourceItem> result = new ArrayList<PsiDataBindingResourceItem>();
                for (DataBindingInfo dataBindingInfo : this.myInfoList) {
                    List<PsiDataBindingResourceItem> items = dataBindingInfo.getItems(type);
                    for (PsiDataBindingResourceItem item : items) {
                        if (!used.add(item.getName())) continue;
                        result.add(item);
                    }
                }
                return CachedValueProvider.Result.create(result, this.myInfoList);
            }, false);
        }
    }

    public LayoutDataBindingInfo selectBaseInfo() {
        LayoutDataBindingInfo best = null;
        for (LayoutDataBindingInfo info : this.myInfoList) {
            if (best != null && best.getConfigurationName().length() <= info.getConfigurationName().length()) continue;
            best = info;
        }
        return best;
    }

    @Override
    public AndroidFacet getFacet() {
        return this.myBaseInfo.getFacet();
    }

    @Override
    public String getClassName() {
        return this.myBaseInfo.getNonConfigurationClassName();
    }

    @Override
    public String getPackageName() {
        return this.myBaseInfo.getPackageName();
    }

    @Override
    public Project getProject() {
        return this.myBaseInfo.getProject();
    }

    @Override
    public String getQualifiedName() {
        return this.myBaseInfo.getPackageName() + "." + this.getClassName();
    }

    @Override
    public PsiElement getNavigationElement() {
        return this.myBaseInfo.getNavigationElement();
    }

    @Override
    public PsiFile getPsiFile() {
        return this.myBaseInfo.getPsiFile();
    }

    @Override
    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @Override
    public void setPsiClass(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    @Override
    @NotNull
    public List<PsiDataBindingResourceItem> getItems(DataBindingResourceType type) {
        List list = (List)this.myResourceItemCache[type.ordinal()].getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/MergedDataBindingInfo", "getItems"));
        }
        return list;
    }

    @Override
    public List<DataBindingInfo.ViewWithId> getViewsWithIds() {
        return (List)this.myViewWithIdsCache.getValue();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myBaseInfo.getModule();
    }

    @Override
    public long getModificationCount() {
        int total = this.myInfoList.size();
        for (DataBindingInfo dataBindingInfo : this.myInfoList) {
            total = (int)((long)total + dataBindingInfo.getModificationCount());
        }
        return total;
    }

    @Override
    public boolean isMerged() {
        return true;
    }

    @Override
    @Nullable
    public DataBindingInfo getMergedInfo() {
        return null;
    }

    private static /* synthetic */ void lambda$null$0(Set used, List result, DataBindingInfo.ViewWithId viewWithId) {
        if (used.add(viewWithId.name)) {
            result.add(viewWithId);
        }
    }
}

