/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployTargetContext
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(DeployTargetContext.class);
    public String TARGET_SELECTION_MODE = TargetSelectionMode.SHOW_DIALOG.name();
    private final List<DeployTargetProvider> myDeployTargetProviders = DeployTargetProvider.getProviders();
    private final Map<String, DeployTargetState> myDeployTargetStates;

    public DeployTargetContext() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeployTargetProvider provider : this.myDeployTargetProviders) {
            builder.put((Object)provider.getId(), provider.createState());
        }
        this.myDeployTargetStates = builder.build();
    }

    @NotNull
    public List<DeployTargetProvider> getDeployTargetProviders() {
        List<DeployTargetProvider> list = this.myDeployTargetProviders;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetContext", "getDeployTargetProviders"));
        }
        return list;
    }

    @NotNull
    public DeployTargetProvider getCurrentDeployTargetProvider() {
        DeployTargetProvider target = this.getDeployTargetProvider(this.TARGET_SELECTION_MODE);
        if (target == null) {
            target = this.getDeployTargetProvider(TargetSelectionMode.SHOW_DIALOG.name());
        }
        assert (target != null);
        DeployTargetProvider deployTargetProvider = target;
        if (deployTargetProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetContext", "getCurrentDeployTargetProvider"));
        }
        return deployTargetProvider;
    }

    @Nullable
    private DeployTargetProvider getDeployTargetProvider(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/run/editor/DeployTargetContext", "getDeployTargetProvider"));
        }
        for (DeployTargetProvider target : this.myDeployTargetProviders) {
            if (!target.getId().equals(id)) continue;
            return target;
        }
        return null;
    }

    @NotNull
    public Map<String, DeployTargetState> getDeployTargetStates() {
        Map<String, DeployTargetState> map = this.myDeployTargetStates;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetContext", "getDeployTargetStates"));
        }
        return map;
    }

    @NotNull
    public DeployTargetState getCurrentDeployTargetState() {
        DeployTargetProvider currentTarget = this.getCurrentDeployTargetProvider();
        DeployTargetState deployTargetState = this.myDeployTargetStates.get(currentTarget.getId());
        if (deployTargetState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetContext", "getCurrentDeployTargetState"));
        }
        return deployTargetState;
    }

    @NotNull
    public DeployTargetState getDeployTargetState(@NotNull DeployTargetProvider target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/run/editor/DeployTargetContext", "getDeployTargetState"));
        }
        DeployTargetState deployTargetState = this.myDeployTargetStates.get(target.getId());
        if (deployTargetState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetContext", "getDeployTargetState"));
        }
        return deployTargetState;
    }

    public void setTargetSelectionMode(@NotNull TargetSelectionMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/run/editor/DeployTargetContext", "setTargetSelectionMode"));
        }
        this.TARGET_SELECTION_MODE = mode.name();
    }

    public void setTargetSelectionMode(@NotNull DeployTargetProvider target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/run/editor/DeployTargetContext", "setTargetSelectionMode"));
        }
        this.TARGET_SELECTION_MODE = target.getId();
    }

    @NotNull
    public TargetSelectionMode getTargetSelectionMode() {
        TargetSelectionMode targetSelectionMode;
        try {
            targetSelectionMode = TargetSelectionMode.valueOf(this.TARGET_SELECTION_MODE);
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            TargetSelectionMode targetSelectionMode2 = TargetSelectionMode.EMULATOR;
            if (targetSelectionMode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetContext", "getTargetSelectionMode"));
            }
            return targetSelectionMode2;
        }
        if (targetSelectionMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetContext", "getTargetSelectionMode"));
        }
        return targetSelectionMode;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state, (Element)element);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state, (Element)element);
        }
    }
}

