/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.editor.LaunchOption;
import com.android.tools.idea.run.editor.LaunchOptionConfigurable;
import com.android.tools.idea.run.editor.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.editor.LaunchOptionState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchConfigurableWrapper
implements Configurable,
Configurable.NoScroll,
Configurable.NoMargin {
    private final Project myProject;
    private final LaunchOptionConfigurableContext myContext;
    private final LaunchOption myOption;
    private LaunchOptionConfigurable myConfigurable;

    public LaunchConfigurableWrapper(@NotNull Project project, @NotNull LaunchOptionConfigurableContext context, @NotNull LaunchOption option) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/LaunchConfigurableWrapper", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/run/editor/LaunchConfigurableWrapper", "<init>"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/android/tools/idea/run/editor/LaunchConfigurableWrapper", "<init>"));
        }
        this.myProject = project;
        this.myContext = context;
        this.myOption = option;
    }

    @Nls
    public String getDisplayName() {
        return this.myOption.getDisplayName();
    }

    @Nullable
    public JComponent createComponent() {
        return this.getConfigurable().createComponent();
    }

    public void resetFrom(@NotNull LaunchOptionState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/LaunchConfigurableWrapper", "resetFrom"));
        }
        this.getConfigurable().resetFrom(state);
    }

    public void applyTo(@NotNull LaunchOptionState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/LaunchConfigurableWrapper", "applyTo"));
        }
        this.getConfigurable().applyTo(state);
    }

    private LaunchOptionConfigurable getConfigurable() {
        if (this.myConfigurable == null) {
            this.myConfigurable = this.myOption.createConfigurable(this.myProject, this.myContext);
        }
        return this.myConfigurable;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }
}

