/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.fd.client.InstantRunPushFailedException;
import com.android.tools.fd.client.UpdateMode;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class DexDeployTask
implements LaunchTask {
    private final Project myProject;
    private final InstantRunContext myInstantRunContext;

    public DexDeployTask(@NotNull Project project, @NotNull InstantRunContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/DexDeployTask", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/run/tasks/DexDeployTask", "<init>"));
        }
        this.myProject = project;
        this.myInstantRunContext = context;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Installing restart patches" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/DexDeployTask", "getDescription"));
        }
        return "Installing restart patches";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/DexDeployTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/DexDeployTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/DexDeployTask", "perform"));
        }
        try {
            InstantRunManager manager = InstantRunManager.get(this.myProject);
            manager.pushArtifacts(device, this.myInstantRunContext, UpdateMode.HOT_SWAP);
            printer.stdout("Cold swapped changes.");
            InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.DEX, this.myInstantRunContext, device);
            return true;
        }
        catch (InstantRunPushFailedException | IOException e) {
            launchStatus.terminateLaunch("Error installing cold swap patches: " + e);
            InstantRunManager.LOG.warn("Failed to push dex files: ", e);
            return false;
        }
    }
}

