/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdks {
    @NonNls
    public static final String SDK_NAME_PREFIX = "Android ";
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final Jdks myJdks;
    @Nullable
    private AndroidSdkData mySdkData;

    @NotNull
    public static AndroidSdks getInstance() {
        AndroidSdks androidSdks = (AndroidSdks)ServiceManager.getService(AndroidSdks.class);
        if (androidSdks == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "getInstance"));
        }
        return androidSdks;
    }

    public AndroidSdks(@NotNull Jdks jdks, @NotNull IdeInfo ideInfo) {
        if (jdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdks", "com/android/tools/idea/sdk/AndroidSdks", "<init>"));
        }
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/sdk/AndroidSdks", "<init>"));
        }
        this.myIdeInfo = ideInfo;
        this.myJdks = jdks;
    }

    @Nullable
    public File findPathOfSdkWithoutAddonsFolder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/sdk/AndroidSdks", "findPathOfSdkWithoutAddonsFolder"));
        }
        if (this.myIdeInfo.isAndroidStudio()) {
            File sdkPath = IdeSdks.getInstance().getAndroidSdkPath();
            if (sdkPath != null && AndroidSdks.isMissingAddonsFolder(sdkPath)) {
                return sdkPath;
            }
        } else {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            for (Module module : moduleManager.getModules()) {
                File sdkHomePath;
                String homePath;
                Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (moduleSdk == null || !this.isAndroidSdk(moduleSdk) || (homePath = moduleSdk.getHomePath()) == null || !AndroidSdks.isMissingAddonsFolder(sdkHomePath = new File(FileUtil.toSystemDependentName((String)homePath)))) continue;
                return sdkHomePath;
            }
        }
        return null;
    }

    private static boolean isMissingAddonsFolder(@NotNull File sdkHomePath) {
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/android/tools/idea/sdk/AndroidSdks", "isMissingAddonsFolder"));
        }
        File addonsFolder = new File(sdkHomePath, "add-ons");
        return !addonsFolder.isDirectory() || FileUtil.notNullize((File[])addonsFolder.listFiles()).length == 0;
    }

    @Nullable
    public Sdk findSuitableAndroidSdk(@NotNull String targetHash) {
        if (targetHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetHash", "com/android/tools/idea/sdk/AndroidSdks", "findSuitableAndroidSdk"));
        }
        HashSet<String> foundSdkHomePaths = new HashSet<String>();
        ArrayList<Sdk> notCompatibleSdks = new ArrayList<Sdk>();
        for (Sdk sdk : this.getAllAndroidSdks()) {
            String sdkHomePath;
            AndroidSdkAdditionalData originalData = this.getAndroidSdkAdditionalData(sdk);
            if (originalData == null || foundSdkHomePaths.contains(sdkHomePath = sdk.getHomePath()) || !targetHash.equals(originalData.getBuildTargetHashString())) continue;
            if (VersionCheck.isCompatibleVersion(sdkHomePath)) {
                return sdk;
            }
            notCompatibleSdks.add(sdk);
            if (sdkHomePath == null) continue;
            foundSdkHomePaths.add(sdkHomePath);
        }
        return notCompatibleSdks.isEmpty() ? null : (Sdk)notCompatibleSdks.get(0);
    }

    @Nullable
    public AndroidSdkAdditionalData getAndroidSdkAdditionalData(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/sdk/AndroidSdks", "getAndroidSdkAdditionalData"));
        }
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        return data instanceof AndroidSdkAdditionalData ? (AndroidSdkAdditionalData)data : null;
    }

    public void setSdkData(@Nullable AndroidSdkData data) {
        this.mySdkData = data;
    }

    @NotNull
    public AndroidSdkHandler tryToChooseSdkHandler() {
        AndroidSdkData data = this.tryToChooseAndroidSdk();
        AndroidSdkHandler androidSdkHandler = data != null ? data.getSdkHandler() : AndroidSdkHandler.getInstance(null);
        if (androidSdkHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "tryToChooseSdkHandler"));
        }
        return androidSdkHandler;
    }

    @Nullable
    public AndroidSdkData tryToChooseAndroidSdk() {
        if (this.mySdkData == null) {
            File path;
            if (this.myIdeInfo.isAndroidStudio() && (path = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                this.mySdkData = AndroidSdkData.getSdkData(path);
                if (this.mySdkData != null) {
                    return this.mySdkData;
                }
            }
            for (File path2 : this.getAndroidSdkPathsFromExistingPlatforms()) {
                this.mySdkData = AndroidSdkData.getSdkData(path2);
                if (this.mySdkData == null) continue;
                break;
            }
        }
        return this.mySdkData;
    }

    @NotNull
    public Collection<File> getAndroidSdkPathsFromExistingPlatforms() {
        ArrayList<File> result = new ArrayList<File>();
        for (Sdk androidSdk : this.getAllAndroidSdks()) {
            File sdkPath;
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(androidSdk);
            if (androidPlatform == null || result.contains(sdkPath = androidPlatform.getSdkData().getLocation())) continue;
            if (androidSdk.getName().startsWith(SDK_NAME_PREFIX)) {
                result.add(0, sdkPath);
                continue;
            }
            result.add(sdkPath);
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "getAndroidSdkPathsFromExistingPlatforms"));
        }
        return arrayList;
    }

    @NotNull
    public List<Sdk> getAllAndroidSdks() {
        List<Sdk> allSdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)AndroidSdkType.getInstance());
        List<Sdk> list = allSdks != null ? allSdks : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "getAllAndroidSdks"));
        }
        return list;
    }

    @Nullable
    public Sdk tryToCreate(@NotNull File sdkPath, @NotNull String targetHashString) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/android/tools/idea/sdk/AndroidSdks", "tryToCreate"));
        }
        if (targetHashString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetHashString", "com/android/tools/idea/sdk/AndroidSdks", "tryToCreate"));
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdkPath);
        if (sdkData != null) {
            sdkData.getSdkHandler().getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(AndroidSdks.class)).markInvalid();
            IAndroidTarget target = sdkData.findTargetByHashString(targetHashString);
            if (target != null) {
                return this.create(target, sdkData.getLocation(), true);
            }
        }
        return null;
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, boolean addRoots) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "create"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/android/tools/idea/sdk/AndroidSdks", "create"));
        }
        Sdk jdk = this.myJdks.chooseOrCreateJavaSdk();
        return jdk != null ? this.create(target, sdkPath, jdk, addRoots) : null;
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, @NotNull Sdk jdk, boolean addRoots) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "create"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/android/tools/idea/sdk/AndroidSdks", "create"));
        }
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/android/tools/idea/sdk/AndroidSdks", "create"));
        }
        return this.create(target, sdkPath, this.chooseNameForNewLibrary(target), jdk, addRoots);
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, @NotNull String sdkName, @NotNull Sdk jdk, boolean addRoots) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "create"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/android/tools/idea/sdk/AndroidSdks", "create"));
        }
        if (sdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkName", "com/android/tools/idea/sdk/AndroidSdks", "create"));
        }
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/android/tools/idea/sdk/AndroidSdks", "create"));
        }
        if (!target.getAdditionalLibraries().isEmpty()) {
            return null;
        }
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        String tempName = SdkConfigurationUtil.createUniqueSdkName((String)"Android SDK", Arrays.asList(table.getAllJdks()));
        Sdk sdk = table.createSdk(tempName, (SdkTypeId)AndroidSdkType.getInstance());
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.setHomePath(sdkPath.getPath());
        this.setUpSdk(sdk, sdkModificator, target, sdkName, Arrays.asList(table.getAllJdks()), jdk, addRoots);
        sdkModificator.commitChanges();
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk));
        return sdk;
    }

    public void setUpSdk(@NotNull Sdk androidSdk, @NotNull IAndroidTarget target, @NotNull String sdkName, @NotNull Collection<Sdk> allSdks, @Nullable Sdk jdk, boolean addRoots) {
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdk", "com/android/tools/idea/sdk/AndroidSdks", "setUpSdk"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "setUpSdk"));
        }
        if (sdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkName", "com/android/tools/idea/sdk/AndroidSdks", "setUpSdk"));
        }
        if (allSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allSdks", "com/android/tools/idea/sdk/AndroidSdks", "setUpSdk"));
        }
        SdkModificator sdkModificator = androidSdk.getSdkModificator();
        this.setUpSdk(androidSdk, sdkModificator, target, sdkName, allSdks, jdk, addRoots);
        sdkModificator.commitChanges();
    }

    public void setUpSdk(@NotNull Sdk androidSdk, @NotNull SdkModificator androidSdkModificator, @NotNull IAndroidTarget target, @NotNull String sdkName, @NotNull Collection<Sdk> allSdks, @Nullable Sdk jdk, boolean addRoots) {
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdk", "com/android/tools/idea/sdk/AndroidSdks", "setUpSdk"));
        }
        if (androidSdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkModificator", "com/android/tools/idea/sdk/AndroidSdks", "setUpSdk"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "setUpSdk"));
        }
        if (sdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkName", "com/android/tools/idea/sdk/AndroidSdks", "setUpSdk"));
        }
        if (allSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allSdks", "com/android/tools/idea/sdk/AndroidSdks", "setUpSdk"));
        }
        AndroidSdkAdditionalData data = new AndroidSdkAdditionalData(androidSdk, jdk);
        data.setBuildTarget(target);
        String name = SdkConfigurationUtil.createUniqueSdkName((String)sdkName, allSdks);
        androidSdkModificator.setName(name);
        if (jdk != null) {
            androidSdkModificator.setVersionString(jdk.getVersionString());
        }
        androidSdkModificator.setSdkAdditionalData((SdkAdditionalData)data);
        if (addRoots) {
            List<OrderRoot> newRoots = this.getLibraryRootsForTarget(target, androidSdk, true);
            androidSdkModificator.removeAllRoots();
            for (OrderRoot orderRoot : newRoots) {
                androidSdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
            }
            ExternalAnnotationsSupport.attachJdkAnnotations(androidSdkModificator);
        }
        this.findAndSetPlatformSources(target, androidSdkModificator);
    }

    public void findAndSetPlatformSources(@NotNull IAndroidTarget target, @NotNull SdkModificator sdkModificator) {
        VirtualFile virtualFile;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "findAndSetPlatformSources"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/android/tools/idea/sdk/AndroidSdks", "findAndSetPlatformSources"));
        }
        File sources = this.findPlatformSources(target);
        if (sources != null && (virtualFile = VfsUtil.findFileByIoFile((File)sources, (boolean)true)) != null) {
            for (VirtualFile file : sdkModificator.getRoots(OrderRootType.SOURCES)) {
                if (!file.equals(virtualFile)) continue;
                return;
            }
            sdkModificator.addRoot(virtualFile, OrderRootType.SOURCES);
        }
    }

    @Nullable
    public File findPlatformSources(@NotNull IAndroidTarget target) {
        File platformSource;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "findPlatformSources"));
        }
        String path = target.getPath(18);
        if (path != null && (platformSource = new File(path)).isDirectory()) {
            return platformSource;
        }
        return null;
    }

    @NotNull
    public List<OrderRoot> getLibraryRootsForTarget(@NotNull IAndroidTarget target, @NotNull Sdk androidSdk, boolean addPlatformAndAddOnJars) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "getLibraryRootsForTarget"));
        }
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdk", "com/android/tools/idea/sdk/AndroidSdks", "getLibraryRootsForTarget"));
        }
        List<OrderRoot> list = this.getLibraryRootsForTarget(target, AndroidSdks.getHomePath(androidSdk), addPlatformAndAddOnJars);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "getLibraryRootsForTarget"));
        }
        return list;
    }

    @Nullable
    private static File getHomePath(@NotNull Sdk androidSdk) {
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdk", "com/android/tools/idea/sdk/AndroidSdks", "getHomePath"));
        }
        String sdkPathValue = androidSdk.getHomePath();
        return StringUtil.isNotEmpty((String)sdkPathValue) ? new File(sdkPathValue) : null;
    }

    @NotNull
    public List<OrderRoot> getLibraryRootsForTarget(@NotNull IAndroidTarget target, @Nullable File sdkPath, boolean addPlatformAndAddOnJars) {
        File annotationsJarPath;
        VirtualFile annotationsJar;
        VirtualFile resFolder;
        String resFolderPath;
        VirtualFile javadoc;
        VirtualFile platformSourcesDir;
        VirtualFile platformFolder;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "getLibraryRootsForTarget"));
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        if (addPlatformAndAddOnJars) {
            for (VirtualFile file : this.getPlatformAndAddOnJars(target)) {
                result.add(new OrderRoot(file, OrderRootType.CLASSES));
            }
        }
        if ((platformFolder = AndroidSdks.getPlatformFolder(target)) == null) {
            ArrayList<OrderRoot> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "getLibraryRootsForTarget"));
            }
            return arrayList;
        }
        VirtualFile targetDir = platformFolder;
        if (!target.isPlatform()) {
            targetDir = AndroidSdks.findFileInLocalFileSystem(target.getLocation());
        }
        boolean docsOrSourcesFound = false;
        if (targetDir != null) {
            docsOrSourcesFound = AndroidSdks.addJavaDocAndSources(result, targetDir);
        }
        VirtualFile sdkDir = sdkPath != null ? AndroidSdks.findFileInLocalFileSystem(sdkPath.getPath()) : null;
        VirtualFile sourcesDir = null;
        if (sdkDir != null) {
            docsOrSourcesFound = AndroidSdks.addJavaDocAndSources(result, sdkDir) || docsOrSourcesFound;
            sourcesDir = sdkDir.findChild("sources");
        }
        if (sourcesDir != null && sourcesDir.isDirectory() && (platformSourcesDir = sourcesDir.findChild(platformFolder.getName())) != null && platformSourcesDir.isDirectory()) {
            result.add(new OrderRoot(platformSourcesDir, OrderRootType.SOURCES));
            docsOrSourcesFound = true;
        }
        if (!docsOrSourcesFound && (javadoc = VirtualFileManager.getInstance().findFileByUrl("http://developer.android.com/reference/")) != null) {
            result.add(new OrderRoot(javadoc, JavadocOrderRootType.getInstance()));
        }
        if ((resFolderPath = target.getPath(11)) != null && (resFolder = AndroidSdks.findFileInLocalFileSystem(resFolderPath)) != null) {
            result.add(new OrderRoot(resFolder, OrderRootType.CLASSES));
        }
        if (sdkPath != null && this.needsAnnotationsJarInClasspath(target) && (annotationsJar = AndroidSdks.findFileInJarFileSystem(annotationsJarPath = new File(sdkPath, FileUtil.toSystemDependentName((String)"/tools/support/annotations.jar")))) != null) {
            result.add(new OrderRoot(annotationsJar, OrderRootType.CLASSES));
        }
        ArrayList<OrderRoot> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "getLibraryRootsForTarget"));
        }
        return arrayList;
    }

    @NotNull
    public List<VirtualFile> getPlatformAndAddOnJars(@NotNull IAndroidTarget target) {
        VirtualFile androidJar;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "getPlatformAndAddOnJars"));
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile platformFolder = AndroidSdks.getPlatformFolder(target);
        if (platformFolder != null && (androidJar = platformFolder.findChild("android.jar")) != null) {
            File androidJarPath = VfsUtilCore.virtualToIoFile((VirtualFile)androidJar);
            VirtualFile androidJarRoot = AndroidSdks.findFileInJarFileSystem(androidJarPath);
            if (androidJarRoot != null) {
                result.add(androidJarRoot);
            }
            List libraries = target.getAdditionalLibraries();
            for (IAndroidTarget.OptionalLibrary library : libraries) {
                VirtualFile root = AndroidSdks.getRoot(library);
                if (root == null) continue;
                result.add(root);
            }
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "getPlatformAndAddOnJars"));
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile getPlatformFolder(@NotNull IAndroidTarget target) {
        String platformPath;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "getPlatformFolder"));
        }
        String string = platformPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        if (platformPath == null) {
            return null;
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)platformPath));
    }

    @Nullable
    private static VirtualFile getRoot(@NotNull IAndroidTarget.OptionalLibrary library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/sdk/AndroidSdks", "getRoot"));
        }
        File jar = library.getJar();
        if (jar != null) {
            return AndroidSdks.findFileInJarFileSystem(jar);
        }
        return null;
    }

    private static boolean addJavaDocAndSources(@NotNull List<OrderRoot> orderRoots, @NotNull VirtualFile sdkFolder) {
        VirtualFile sourcesFolder;
        if (orderRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderRoots", "com/android/tools/idea/sdk/AndroidSdks", "addJavaDocAndSources"));
        }
        if (sdkFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkFolder", "com/android/tools/idea/sdk/AndroidSdks", "addJavaDocAndSources"));
        }
        boolean found = false;
        VirtualFile javadocFolder = AndroidSdks.findJavadocFolder(sdkFolder);
        if (javadocFolder != null) {
            orderRoots.add(new OrderRoot(javadocFolder, JavadocOrderRootType.getInstance()));
            found = true;
        }
        if ((sourcesFolder = sdkFolder.findChild("src")) != null) {
            orderRoots.add(new OrderRoot(sourcesFolder, OrderRootType.SOURCES));
            found = true;
        }
        return found;
    }

    @Nullable
    private static VirtualFile findJavadocFolder(@NotNull VirtualFile folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/sdk/AndroidSdks", "findJavadocFolder"));
        }
        VirtualFile docsFolder = folder.findChild("docs");
        return docsFolder != null ? docsFolder.findChild("reference") : null;
    }

    @Nullable
    private static VirtualFile findFileInLocalFileSystem(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/AndroidSdks", "findFileInLocalFileSystem"));
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemDependentName((String)path));
    }

    @Nullable
    private static VirtualFile findFileInJarFileSystem(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/AndroidSdks", "findFileInJarFileSystem"));
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)path.getPath());
        return JarFileSystem.getInstance().findFileByPath(canonicalPath + "!/");
    }

    @NotNull
    public String chooseNameForNewLibrary(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "chooseNameForNewLibrary"));
        }
        if (target.isPlatform()) {
            String string = SDK_NAME_PREFIX + target.getVersion().toString() + " Platform";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "chooseNameForNewLibrary"));
            }
            return string;
        }
        IAndroidTarget parentTarget = target.getParent();
        String name = SDK_NAME_PREFIX;
        if (parentTarget != null) {
            name = name + parentTarget.getVersionName() + ' ';
        }
        String string = name + target.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/AndroidSdks", "chooseNameForNewLibrary"));
        }
        return string;
    }

    public boolean isAndroidSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/sdk/AndroidSdks", "isAndroidSdk"));
        }
        return sdk.getSdkType() == AndroidSdkType.getInstance();
    }

    public boolean needsAnnotationsJarInClasspath(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/AndroidSdks", "needsAnnotationsJarInClasspath"));
        }
        return target.getVersion().getApiLevel() <= 15;
    }

    public void refreshLibrariesIn(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/sdk/AndroidSdks", "refreshLibrariesIn"));
        }
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        this.replaceLibraries(sdk, libraries);
    }

    @VisibleForTesting
    void replaceLibraries(@NotNull Sdk sdk, @NotNull VirtualFile[] libraries) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/sdk/AndroidSdks", "replaceLibraries"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/android/tools/idea/sdk/AndroidSdks", "replaceLibraries"));
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }
}

