/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install;

import com.android.repository.api.InstallerFactory;
import com.android.repository.impl.installer.BasicInstallerFactory;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.install.StudioSdkInstallListenerFactory;
import com.android.tools.idea.sdk.install.patch.PatchInstallerFactory;
import org.jetbrains.annotations.NotNull;

public final class StudioSdkInstallerUtil {
    @NotNull
    public static InstallerFactory createInstallerFactory(@NotNull AndroidSdkHandler sdkHandler) {
        Object factory;
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/sdk/install/StudioSdkInstallerUtil", "createInstallerFactory"));
        }
        BasicInstallerFactory basicFactory = new BasicInstallerFactory();
        if (Boolean.getBoolean("sdk.patches.disable")) {
            factory = basicFactory;
        } else {
            factory = new PatchInstallerFactory();
            factory.setFallbackFactory((InstallerFactory)basicFactory);
        }
        factory.setListenerFactory((InstallerFactory.StatusChangeListenerFactory)new StudioSdkInstallListenerFactory(sdkHandler));
        Object object = factory;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/StudioSdkInstallerUtil", "createInstallerFactory"));
        }
        return object;
    }

    private StudioSdkInstallerUtil() {
    }
}

