/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Uninstaller;
import com.android.repository.impl.installer.AbstractInstallerFactory;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.tools.idea.sdk.install.patch.FullInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchRunner;
import com.android.tools.idea.sdk.install.patch.PatchUninstaller;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchInstallerFactory
extends AbstractInstallerFactory {
    private static final String KNOWN_GOOD_VERSION = "patcher;v4";

    @NotNull
    protected Installer doCreateInstaller(@NotNull RemotePackage remote, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        if (mgr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        if (downloader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloader", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        LocalPackage local = (LocalPackage)mgr.getPackages().getLocalPackages().get(remote.getPath());
        if (PatchInstallerFactory.hasPatch(local, remote)) {
            PatchInstaller patchInstaller = new PatchInstaller(local, remote, downloader, mgr, fop);
            if (patchInstaller == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
            }
            return patchInstaller;
        }
        FullInstaller fullInstaller = new FullInstaller(local, remote, mgr, downloader, fop);
        if (fullInstaller == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        return fullInstaller;
    }

    private static boolean hasPatch(@Nullable LocalPackage local, @NotNull RemotePackage remote) {
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "hasPatch"));
        }
        Archive archive = remote.getArchive();
        assert (archive != null);
        return local != null && archive.getPatch(local.getVersion()) != null;
    }

    @NotNull
    protected Uninstaller doCreateUninstaller(@NotNull LocalPackage local, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateUninstaller"));
        }
        if (mgr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateUninstaller"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateUninstaller"));
        }
        PatchUninstaller patchUninstaller = new PatchUninstaller(local, mgr, fop);
        if (patchUninstaller == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateUninstaller"));
        }
        return patchUninstaller;
    }

    protected boolean canHandlePackage(@NotNull RepoPackage p, @NotNull RepoManager manager, @NotNull FileOp fop) {
        LocalPackage patcher;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "canHandlePackage"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "canHandlePackage"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "canHandlePackage"));
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(PatchInstallerFactory.class);
        if (p instanceof LocalPackage) {
            if (fop.isWindows()) {
                LocalPackage latestPatcher = PatchInstallerUtil.getLatestPatcher(manager);
                return latestPatcher != null && !latestPatcher.equals(p);
            }
            return false;
        }
        LocalPackage local = (LocalPackage)manager.getPackages().getLocalPackages().get(p.getPath());
        RemotePackage remote = (RemotePackage)p;
        if (local == null || !fop.isWindows() && !PatchInstallerFactory.hasPatch(local, remote)) {
            return false;
        }
        if (PatchInstallerFactory.hasPatch(local, remote)) {
            patcher = PatchInstallerUtil.getDependantPatcher((RemotePackage)p, manager);
            if (patcher != null && PatchRunner.getPatchRunner(patcher, (ProgressIndicator)progress, fop) != null) {
                return true;
            }
            if (PatchInstallerUtil.getInProgressDependantPatcherInstall((RemotePackage)p, manager) != null) {
                return true;
            }
        }
        return (patcher = PatchInstallerUtil.getLatestPatcher(manager)) != null && PatchInstallerUtil.comparePatcherPaths(patcher.getPath(), KNOWN_GOOD_VERSION) >= 0;
    }
}

