/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.templates.GradleFileMergers;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class GradleFileSimpleMerger {
    public static String mergeGradleFiles(@NotNull String source, @NotNull String dest, @Nullable Project project, @Nullable String supportLibVersionFilter) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/templates/GradleFileSimpleMerger", "mergeGradleFiles"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/GradleFileSimpleMerger", "mergeGradleFiles"));
        }
        SimpleGradleBuildFileParser templateParser = new SimpleGradleBuildFileParser(source);
        Ast template = templateParser.parse();
        assert (template != null);
        SimpleGradleBuildFileParser existingParser = new SimpleGradleBuildFileParser(dest);
        Ast existing = existingParser.parse();
        PrintContext printContext = new PrintContext();
        if (existing != null) {
            MergeContext mergeContext = new MergeContext(project, supportLibVersionFilter);
            existing.merge(mergeContext, template);
            existing.print(printContext);
        } else {
            template.print(printContext);
        }
        return printContext.toString();
    }

    private static Logger getLogger() {
        return Logger.getInstance(GradleFileSimpleMerger.class);
    }

    private static class MergeContext {
        private final Project myProject;
        private final String myFilter;

        public MergeContext(@Nullable Project project, @Nullable String supportLibVersionFilter) {
            this.myProject = project;
            this.myFilter = supportLibVersionFilter;
        }

        String getFilter() {
            return this.myFilter;
        }

        Project getProject() {
            return this.myProject;
        }
    }

    private static class PrintContext {
        private int myIndent = 0;
        private StringBuilder myBuilder = new StringBuilder();

        public PrintContext append(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/templates/GradleFileSimpleMerger$PrintContext", "append"));
            }
            if (this.atStartOfLine() && !value.startsWith("\n")) {
                this.appendIndent();
            }
            this.myBuilder.append(value);
            return this;
        }

        void increaseIndent() {
            ++this.myIndent;
        }

        void decreaseIndent() {
            --this.myIndent;
        }

        void removePreviousSingleSpaceChar() {
            int len = this.myBuilder.length();
            if (len > 1 && this.myBuilder.charAt(len - 1) == ' ' && Character.isJavaIdentifierPart(len - 2)) {
                this.myBuilder.setLength(this.myBuilder.length() - 1);
            }
        }

        void appendNewLineIfNoIndent() {
            if (this.myIndent == 0) {
                this.myBuilder.append("\n");
            }
        }

        private boolean atStartOfLine() {
            if (this.myBuilder.length() == 0) {
                return true;
            }
            return this.myBuilder.charAt(this.myBuilder.length() - 1) == '\n';
        }

        private void appendIndent() {
            for (int index = 0; index < this.myIndent; ++index) {
                this.myBuilder.append("    ");
            }
        }

        public String toString() {
            return this.myBuilder.toString();
        }
    }

    private static class UnknownAstNode
    extends Ast {
        @NotNull
        private String myText;

        public UnknownAstNode(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/templates/GradleFileSimpleMerger$UnknownAstNode", "<init>"));
            }
            this.myText = text;
        }

        @Override
        public void print(@NotNull PrintContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/GradleFileSimpleMerger$UnknownAstNode", "print"));
            }
            if (!this.myText.isEmpty() && !Character.isJavaIdentifierPart(this.myText.charAt(0))) {
                context.removePreviousSingleSpaceChar();
            }
            context.append(this.myText).append("\n");
            if (this.myNext != null) {
                context.appendNewLineIfNoIndent();
                this.myNext.print(context);
            }
        }

        @Override
        public void merge(@NotNull MergeContext context, @NotNull Ast other) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/GradleFileSimpleMerger$UnknownAstNode", "merge"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/templates/GradleFileSimpleMerger$UnknownAstNode", "merge"));
            }
            if (this.myNext != null) {
                this.myNext.merge(context, other);
            } else {
                this.myNext = other;
            }
        }

        @Override
        protected boolean isComplex() {
            return this.myNext != null;
        }
    }

    private static class ValueListAst
    extends Ast {
        private Set<String> myValues;

        public ValueListAst(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/templates/GradleFileSimpleMerger$ValueListAst", "<init>"));
            }
            this.myValues = Sets.newLinkedHashSetWithExpectedSize((int)(values.size() + 5));
            this.myValues.addAll(values);
        }

        @Override
        public void print(@NotNull PrintContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/GradleFileSimpleMerger$ValueListAst", "print"));
            }
            context.append("= [");
            String separator = "";
            for (String value : this.myValues) {
                context.append(separator);
                context.append(value);
                separator = ", ";
            }
            context.append("]\n");
        }

        @Override
        public void merge(@NotNull MergeContext context, @NotNull Ast other) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/GradleFileSimpleMerger$ValueListAst", "merge"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/templates/GradleFileSimpleMerger$ValueListAst", "merge"));
            }
            if (other instanceof ValueListAst) {
                ValueListAst list = (ValueListAst)other;
                this.myValues.addAll(list.myValues);
            } else {
                GradleFileSimpleMerger.getLogger().warn("Cannot merge value list with a different construct");
            }
        }
    }

    private static class ValueAst
    extends Ast {
        private String myValue;

        public ValueAst(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/templates/GradleFileSimpleMerger$ValueAst", "<init>"));
            }
            this.myValue = value;
        }

        @Override
        public void print(@NotNull PrintContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/GradleFileSimpleMerger$ValueAst", "print"));
            }
            context.append(this.myValue).append("\n");
        }

        @Override
        public void merge(@NotNull MergeContext context, @NotNull Ast other) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/GradleFileSimpleMerger$ValueAst", "merge"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/templates/GradleFileSimpleMerger$ValueAst", "merge"));
            }
            if (other instanceof ValueAst) {
                this.myValue = ((ValueAst)other).myValue;
            }
        }
    }

    private static class AstNode
    extends Ast {
        @Nullable
        protected Ast myParam;

        public AstNode(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/templates/GradleFileSimpleMerger$AstNode", "<init>"));
            }
            this.myId = id;
        }

        @Override
        public void print(@NotNull PrintContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/GradleFileSimpleMerger$AstNode", "print"));
            }
            assert (this.myId != null);
            context.append(this.myId).append(" ");
            if (this.myParam != null) {
                if (this.myParam.isComplex()) {
                    context.increaseIndent();
                    context.append("{\n");
                    this.myParam.print(context);
                    context.decreaseIndent();
                    context.append("}\n");
                } else {
                    this.myParam.print(context);
                }
            }
            if (this.myNext != null) {
                context.appendNewLineIfNoIndent();
                this.myNext.print(context);
            }
        }

        @Override
        public void merge(@NotNull MergeContext context, @NotNull Ast other) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/GradleFileSimpleMerger$AstNode", "merge"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/templates/GradleFileSimpleMerger$AstNode", "merge"));
            }
            assert (this.myId != null);
            Ast first = other;
            Ast similar = other.find(this.myId);
            if (similar instanceof AstNode) {
                first = other.remove(similar);
                AstNode node = (AstNode)similar;
                if (this.myParam == null) {
                    this.myParam = node.myParam;
                } else if (this.myId.equals("dependencies")) {
                    this.mergeDependencies(context, node);
                } else if (node.myParam != null) {
                    this.myParam.merge(context, node.myParam);
                }
            } else if (similar != null) {
                GradleFileSimpleMerger.getLogger().warn("Cannot merge AstNode with a non AstNode");
            }
            if (this.myNext != null && first != null) {
                this.myNext.merge(context, first);
            } else if (first != null) {
                this.myNext = first;
            }
        }

        @Override
        public boolean isComplex() {
            return this.myNext != null || this.myParam != null;
        }

        private void mergeDependencies(@NotNull MergeContext context, @NotNull AstNode other) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/GradleFileSimpleMerger$AstNode", "mergeDependencies"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/templates/GradleFileSimpleMerger$AstNode", "mergeDependencies"));
            }
            HashMap dependencies = Maps.newHashMap();
            ArrayList unparseableDependencies = Lists.newArrayListWithCapacity((int)10);
            this.pullDependenciesIntoMap(dependencies, null);
            other.pullDependenciesIntoMap(dependencies, unparseableDependencies);
            RepositoryUrlManager urlManager = RepositoryUrlManager.get();
            ImmutableList configurations = GradleFileMergers.CONFIGURATION_ORDERING.immutableSortedCopy(dependencies.keySet());
            Ast prev = null;
            AndroidSdkData sdk = AndroidSdks.getInstance().tryToChooseAndroidSdk();
            if (sdk != null) {
                for (String configuration : configurations) {
                    List<GradleCoordinate> resolved = urlManager.resolveDynamicSdkDependencies((Multimap<String, GradleCoordinate>)((Multimap)dependencies.get(configuration)), context.getFilter(), sdk, FileOpUtils.create());
                    prev = this.myParam != null ? this.myParam.findLast() : null;
                    for (GradleCoordinate coordinate : resolved) {
                        AstNode compile = new AstNode(configuration);
                        compile.myParam = new ValueAst("'" + coordinate + "'");
                        if (prev == null) {
                            this.myParam = compile;
                        } else {
                            prev.myNext = compile;
                        }
                        prev = compile;
                    }
                }
            }
            for (Ast node : unparseableDependencies) {
                if (prev == null) {
                    this.myParam = node;
                } else {
                    prev.myNext = node;
                }
                prev = node;
                node.myNext = null;
            }
        }

        private void pullDependenciesIntoMap(@NotNull Map<String, Multimap<String, GradleCoordinate>> dependencies, @Nullable List<Ast> unparseableDependencies) {
            if (dependencies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/templates/GradleFileSimpleMerger$AstNode", "pullDependenciesIntoMap"));
            }
            Ast node = this.myParam;
            Ast prev = null;
            while (node != null) {
                assert (this.myParam != null);
                boolean parsed = false;
                if (node instanceof AstNode) {
                    ValueAst value;
                    String coordinateText;
                    GradleCoordinate coordinate;
                    String configuration = node.myId;
                    AstNode compile = (AstNode)node;
                    if (compile.myParam instanceof ValueAst && (coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateText = StringUtil.unquoteString((String)(value = (ValueAst)compile.myParam).myValue)))) != null) {
                        parsed = true;
                        LinkedHashMultimap map = dependencies.get(configuration);
                        if (map == null) {
                            map = LinkedHashMultimap.create();
                            dependencies.put(configuration, (Multimap<String, GradleCoordinate>)map);
                        }
                        if (!map.get((Object)coordinate.getId()).contains(coordinate)) {
                            map.put((Object)coordinate.getId(), (Object)coordinate);
                            Ast toDelete = node;
                            node = node.myNext;
                            this.myParam = this.remove(toDelete, this.myParam, prev);
                            continue;
                        }
                    }
                }
                if (!parsed && unparseableDependencies != null) {
                    unparseableDependencies.add(node);
                }
                prev = node;
                node = node.myNext;
            }
        }
    }

    private static abstract class Ast {
        @Nullable
        protected String myId = null;
        @Nullable
        protected Ast myNext = null;

        private Ast() {
        }

        public abstract void print(@NotNull PrintContext var1);

        public abstract void merge(@NotNull MergeContext var1, @NotNull Ast var2);

        protected boolean isComplex() {
            return this.myNext != null;
        }

        @Nullable
        private Ast find(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/templates/GradleFileSimpleMerger$Ast", "find"));
            }
            Ast node = this;
            while (node != null && !id.equals(node.myId)) {
                node = node.myNext;
            }
            return node;
        }

        @Nullable
        Ast remove(@NotNull Ast toRemove) {
            if (toRemove == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/android/tools/idea/templates/GradleFileSimpleMerger$Ast", "remove"));
            }
            Ast first = this;
            Ast prev = null;
            Ast node = this;
            while (node != null && toRemove != node) {
                prev = node;
                node = node.myNext;
            }
            if (toRemove == node) {
                first = this.remove(toRemove, first, prev);
            }
            return first;
        }

        Ast remove(@NotNull Ast toRemove, @NotNull Ast first, @Nullable Ast prev) {
            if (toRemove == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/android/tools/idea/templates/GradleFileSimpleMerger$Ast", "remove"));
            }
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/android/tools/idea/templates/GradleFileSimpleMerger$Ast", "remove"));
            }
            Ast newFirst = first;
            if (prev == null) {
                newFirst = toRemove.myNext;
            } else {
                prev.myNext = toRemove.myNext;
            }
            toRemove.myNext = null;
            return newFirst;
        }

        Ast findLast() {
            Ast node = this;
            while (node.myNext != null) {
                node = node.myNext;
            }
            return node;
        }
    }

    private static class SimpleGradleBuildFileParser {
        private GroovyLexer myLexer;
        private IElementType myType;

        public SimpleGradleBuildFileParser(@NotNull String source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/templates/GradleFileSimpleMerger$SimpleGradleBuildFileParser", "<init>"));
            }
            this.myLexer = new GroovyLexer();
            this.myType = null;
            this.myLexer = new GroovyLexer();
            this.myLexer.start((CharSequence)source);
            this.myType = this.myLexer.getTokenType();
        }

        public void next() {
            this.nextKeepWhiteSpace();
            while (this.myType != null && this.myType == TokenType.WHITE_SPACE) {
                this.nextKeepWhiteSpace();
            }
        }

        public void nextKeepWhiteSpace() {
            if (this.myType != null) {
                this.myLexer.advance();
                this.myType = this.myLexer.getTokenType();
            }
        }

        public void skipNewLine() {
            if (this.myType == GroovyTokenTypes.mNLS) {
                this.next();
            }
        }

        @Nullable
        public Ast parse() {
            if (this.myType == null) {
                return null;
            }
            Ast result = this.myType == GroovyTokenTypes.mIDENT ? this.parseBlockOrAssignment() : this.parseUnknown();
            if (this.myType != GroovyTokenTypes.mRCURLY) {
                result.myNext = this.parse();
            }
            return result;
        }

        private Ast parseBlockOrAssignment() {
            assert (this.myType == GroovyTokenTypes.mIDENT);
            LookAheadLexer.LookAheadLexerPosition pos = this.myLexer.getCurrentPosition();
            AstNode node = this.parseIdentifier();
            if (node == null) {
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            if (this.myType == GroovyTokenTypes.mLCURLY) {
                this.next();
                node.myParam = this.parse();
                if (this.myType != GroovyTokenTypes.mRCURLY) {
                    return this.restoreAndParseUnknown((LexerPosition)pos);
                }
                this.next();
                this.skipNewLine();
            } else {
                node.myParam = this.parseValue();
            }
            return node;
        }

        private AstNode parseIdentifier() {
            assert (this.myType == GroovyTokenTypes.mIDENT);
            String identifier = this.myLexer.getTokenText();
            this.next();
            while (this.myType == GroovyTokenTypes.mDOT) {
                this.next();
                if (this.myType != GroovyTokenTypes.mIDENT) {
                    return null;
                }
                identifier = identifier + ".";
                identifier = identifier + this.myLexer.getTokenText();
                this.next();
            }
            return new AstNode(identifier);
        }

        private Ast parseValue() {
            if (this.myType == GroovyTokenTypes.mASSIGN) {
                return this.parseValueList();
            }
            if (this.myType == GroovyTokenTypes.mSTRING_LITERAL || this.myType == GroovyTokenTypes.mGSTRING_LITERAL || this.myType == GroovyTokenTypes.mNUM_INT || this.myType == GroovyTokenTypes.mNUM_BIG_INT || this.myType == GroovyTokenTypes.mNUM_BIG_DECIMAL || this.myType == GroovyTokenTypes.mNUM_FLOAT || this.myType == GroovyTokenTypes.mNUM_DOUBLE || this.myType == GroovyTokenTypes.kFALSE || this.myType == GroovyTokenTypes.kTRUE) {
                String value = this.myLexer.getTokenText();
                this.next();
                this.skipNewLine();
                return new ValueAst(value);
            }
            return this.parseUnknown();
        }

        private Ast parseValueList() {
            LookAheadLexer.LookAheadLexerPosition pos = this.myLexer.getCurrentPosition();
            assert (this.myType == GroovyTokenTypes.mASSIGN);
            this.next();
            if (this.myType != GroovyTokenTypes.mLBRACK) {
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            this.next();
            ArrayList values = Lists.newArrayListWithCapacity((int)10);
            if (!this.findStringLiteral(values)) {
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            while (this.myType == GroovyTokenTypes.mCOMMA) {
                this.next();
                if (this.findStringLiteral(values)) continue;
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            if (this.myType != GroovyTokenTypes.mRBRACK) {
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            this.next();
            this.skipNewLine();
            return new ValueListAst(values);
        }

        private boolean findStringLiteral(List<String> literals) {
            if (this.myType != GroovyTokenTypes.mSTRING_LITERAL) {
                return false;
            }
            literals.add(this.myLexer.getTokenText());
            this.next();
            return true;
        }

        private Ast restoreAndParseUnknown(LexerPosition pos) {
            this.myLexer.restore(pos);
            return this.parseUnknown();
        }

        private Ast parseUnknown() {
            int level = 0;
            StringBuilder builder = new StringBuilder();
            while (this.myType != null) {
                if (this.myType == GroovyTokenTypes.mLCURLY) {
                    ++level;
                } else if (this.myType == GroovyTokenTypes.mRCURLY) {
                    if (--level < 0) {
                        break;
                    }
                } else {
                    if (level == 0 && this.myType == GroovyTokenTypes.mNLS) {
                        this.next();
                        break;
                    }
                    if (level == 0 && this.myType == GroovyTokenTypes.mSL_COMMENT) {
                        builder.append(this.myLexer.getTokenSequence());
                        this.next();
                        break;
                    }
                }
                builder.append(this.myLexer.getTokenSequence());
                this.nextKeepWhiteSpace();
            }
            return new UnknownAstNode(builder.toString());
        }
    }
}

